#include "IrpDispatch.h"
#include "Test.h"
#include "VM/VMR0.h"
#include "BI.h"
#include "VMM/MDER0.h"
#include "VMM/CVCR0.h"

///////////////////////////////////////////////////////////////////////////////////////////////////
// PassThrough IRP Handler

NTSTATUS SSHostMainDriverDispatchPassThrough(
    __in PDEVICE_OBJECT DeviceObject, 
    __in PIRP           Irp
    )
{
	KdPrint(("SSHostDriverDispatchPassThrough\n"));
	IoCompleteRequest(Irp, IO_NO_INCREMENT);
    return STATUS_SUCCESS;
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// IRP_MJ_CREATE IRP Handler

NTSTATUS SSHostMainDriverDispatchCreate(
    __in PDEVICE_OBJECT DeviceObject,
    __in	PIRP           Irp
    )
{
	KdPrint(("SSHostDriverDispatchCreate\n"));
    Irp->IoStatus.Status = SS_SUCCESS;
    Irp->IoStatus.Information = 0;
	IoCompleteRequest(Irp, IO_NO_INCREMENT);
	return STATUS_SUCCESS;
}

NTSTATUS SSHostMainDriverDispatchClose(
    __in PDEVICE_OBJECT DeviceObject,
    __in PIRP           Irp
    )
{
	KdPrint(("SSHostDriverDispatchClose\n"));
    Irp->IoStatus.Status = SS_SUCCESS;
    Irp->IoStatus.Information = 0;
	IoCompleteRequest(Irp, IO_NO_INCREMENT);
	return STATUS_SUCCESS;
}
//called when an io request is send
NTSTATUS SSHostMainDriverDeviceControl(
	__in PDEVICE_OBJECT DeviceObject,
	__in PIRP Irp
	)
{
	//local variabels used later
	PIO_STACK_LOCATION pSL;
	EXERESULT rt = SS_SUCCESS;
	int IoControlCode;
	//int inBufLength;
    //int outBufLength;
	//char *inBuf, *outBuf;
    KIRQL oldIrql;
	NTSTATUS ntStatus = STATUS_SUCCESS;
#ifdef DRIVERTEST
	ntStatus = DriverTest(DeviceObject,Irp);
	return ntStatus;
#endif

	pSL = IoGetCurrentIrpStackLocation(Irp);
    //inBufLength = pSL->Parameters.DeviceIoControl.InputBufferLength;
    //outBufLength = pSL->Parameters.DeviceIoControl.OutputBufferLength;
	//inBuf = Irp->AssociatedIrp.SystemBuffer;
	//outBuf = Irp->AssociatedIrp.SystemBuffer;
	//>
	//<
	IoControlCode = pSL->Parameters.DeviceIoControl.IoControlCode;	
	switch(IoControlCode)
	{ 
	case IOCTL_VM_RUN_WITH_SPEED_UP: 
		KdPrint(("IOCTL_VM_RUN_WITH_SPEED_UP\n"));
        ASSERT(KeGetCurrentIrql() <= DISPATCH_LEVEL);
        KeRaiseIrql(DISPATCH_LEVEL, &oldIrql);
        KeLowerIrql(oldIrql);
		break;
	case IOCTL_VM_RUN_WITH_VT: 
		KdPrint(("IOCTL_VM_RUN_WITH_VT\n"));
        ASSERT(KeGetCurrentIrql() <= DISPATCH_LEVEL);
        KeRaiseIrql(DISPATCH_LEVEL, &oldIrql);
        KeLowerIrql(oldIrql);
		break;
	case IOCTL_VM_RUN_WITH_EMULATE:
		KdPrint(("IOCTL_VM_RUN_WITH_EMULATE\n"));
		rt = VMR0RunWithEmu(Irp);
		break;
	case IOCTL_VM_EXTER_INTERRUPT:
		rt = VMMR0FetchExternInterrupt(Irp);	//ֱӽⲿжϽVMM
		break;
	case IOCTL_VM_POWER_UP: 
		KdPrint(("IOCTL_VM_POWER_UP\n"));
		rt = VMR0PowerUp(Irp);
		if(rt == SS_SUCCESS)
			KdPrint(("ɹ\n"));
		break;
	case IOCTL_VM_POWER_OFF: 
		KdPrint(("IOCTL_VM_POWER_OFF\n"));
		rt = VMR0PowerOff(Irp);
		if(rt == SS_SUCCESS)
			KdPrint(("رճɹ\n"));
		break;
	case IOCTL_VM_RESET: 
		KdPrint(("IOCTL_VM_POWER_RESET\n"));
		break;
	case IOCTL_VM_SUSPEND: 
		KdPrint(("IOCTL_VM_POWER_SUSPEND\n"));
		break;
	case IOCTL_VM_EXTER_CMD:
		rt = VMR0RunCmd(Irp);
		break;
	default:
		rt = SS_NO_SUCH_IOCTL;
	}
 	Irp->IoStatus.Status = CON2NTSTATUS(rt);
	IoCompleteRequest( Irp, IO_NO_INCREMENT );
	return CON2NTSTATUS(rt);
}