#include "general.h"
#include "Function.h"
#include "VMM/Emulator/Emulator.h"
#include "Base/File.h"
#include "VMM/Emulator/_Flags.h"

void DumpMem(unsigned char * start ,int len,int offset){
	int i,j;
	EXERESULT rt = SS_SUCCESS;
	char buf[100];
	for(i=0;i<len/16;i++)
	{
		strcpy(buf,"");
		sprintf(buf,"%s%08XH: ",buf,i*16+offset);
		for(j=0;j<16;j++)
		{
			sprintf(buf,"%s%02X ",buf,*(unsigned char *)(start+i*16+j));
		}
		sprintf(buf,"%s\n",buf);
		KdPrint(("%s",buf));
	}
	if(len%16!=0)
	{
		strcpy(buf,"");
		sprintf(buf,"%s%08XH: ",buf,(len/16)*16+offset);
	}
	for(i=0;i<len%16;i++)
	{
		sprintf(buf,"%s%02X ",buf,*(unsigned char *)(start+len/16*16+i));
	}
	if(len%16!=0)
		KdPrint(("%s\n",buf));
}

void DumpMemToFile(HANDLE FileHandle,unsigned char * start ,int len,int offset){
	int i,j;
	EXERESULT rt = SS_SUCCESS;
	char buf[100];
	/*
	for(i=0;i<len/16;i++)
	{
		strcpy(buf,"");
		sprintf(buf,"%s%08XH: ",buf,i*16+offset);
		for(j=0;j<16;j++)
		{
			sprintf(buf,"%s%02X ",buf,*(unsigned char *)(start+i*16+j));
		}
		sprintf(buf,"%s\r\n",buf);
		FileR0Write(FileHandle,buf,NULL,strlen(buf));
	}
	if(len%16!=0)
	{
		strcpy(buf,"");
		sprintf(buf,"%s%08XH: ",buf,(len/16)*16+offset);
	}
	for(i=0;i<len%16;i++)
	{
		sprintf(buf,"%s%02X ",buf,*(unsigned char *)(start+len/16*16+i));
	}
	if(len%16!=0)
		FileR0Write(FileHandle,buf,NULL,strlen(buf));
	*/
	FileR0Write(FileHandle,start,NULL,len);
}

void DumpCpu(PVOID pEmulator){
	tpEmulator pEm;
	tpReg pReg;
	char * pMem;
	char scs[100]="%08X:";
	int rol,i,m;
	int ssbase;
	bool cf,pf,af,zf,sf,tf,iif,df,of;
	pEm = (tpEmulator)pEmulator;
	pReg = pEm->pReg;
	pMem = pEm->pGPM;
	KdPrint(("EAX:0x%08X  ECX:0x%08X  EDX:0x%08X  EBX:0x%08X \n",
		pReg->_EAX,
		pReg->_ECX,
		pReg->_EDX,
		pReg->_EBX
		));
	KdPrint(("ESP:0x%08X  EBP:0x%08X  ESI:0x%08X  EDI:0x%08X \n",
		pReg->_ESP,
		pReg->_EBP,
		pReg->_ESI,
		pReg->_EDI
		));
	KdPrint(("ES:0x%08X  CS:0x%08X  SS:0x%08X \n",
		pReg->xES.v,
		pReg->xCS.v,
		pReg->xSS.v
		));
	KdPrint(("DS:0x%08X  FS:0x%08X  GS:0x%08X \n",
		pReg->xDS.v,
		pReg->xFS.v,
		pReg->xGS.v
	));

	cf = (pReg->_EFLAGS >> E_CF) & 0x01;
	pf = (pReg->_EFLAGS >> E_PF) & 0x01;
	af = (pReg->_EFLAGS >> E_AF) & 0x01;
	zf = (pReg->_EFLAGS >> E_ZF) & 0x01;
	sf = (pReg->_EFLAGS >> E_SF) & 0x01;
	tf = (pReg->_EFLAGS >> E_TF) & 0x01;
	iif = (pReg->_EFLAGS >> E_IF) & 0x01;
	df = (pReg->_EFLAGS >> E_DF) & 0x01;
	of = (pReg->_EFLAGS >> E_OF) & 0x01;
	KdPrint(("EFLAGS:0x%08X   CF:%d PF:%d AF:%d ZF:%d SF:%d TF:%d IF:%d DF:%d OF:%d \n",
		pReg->_EFLAGS,
		cf,
		pf,
		af,
		zf,
		sf,
		tf,
		iif,
		df,
		of
		));

	KdPrint(("EIP:0x%08X\n",pReg->_EIP));

	if((int)(pReg->_EBP)-(int)pReg->_ESP<=0)
		return;
	rol = ((int)pReg->_EBP-(int)pReg->_ESP)/16;
	m = (pReg->_EBP-pReg->_ESP)%16;
	ssbase = pEm->pReg->xSS.h.Base;
	for(i=0;i<rol;i++)
	{
		KdPrint(("%08X: %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X",
			ssbase+pReg->_ESP+i*16,
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+i*16+0),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+i*16+1),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+i*16+2),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+i*16+3),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+i*16+4),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+i*16+5),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+i*16+6),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+i*16+7),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+i*16+8),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+i*16+9),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+i*16+10),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+i*16+11),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+i*16+12),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+i*16+13),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+i*16+14),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+i*16+15)
			));
	}
	for(i=0;i<m;i++)
	{
		scs[4+i*5+1]=' ';
		scs[4+i*5+2]='%';
		scs[4+i*5+3]='0';
		scs[4+i*5+4]='2';
		scs[4+i*5+5]='X';
	}
	if(m!=0)
	{
	KdPrint((scs,
		ssbase+pReg->_ESP+rol*16,
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+rol*16+0),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+rol*16+1),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+rol*16+2),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+rol*16+3),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+rol*16+4),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+rol*16+5),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+rol*16+6),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+rol*16+7),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+rol*16+8),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+rol*16+9),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+rol*16+10),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+rol*16+11),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+rol*16+12),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+rol*16+13),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+rol*16+14),
			*(unsigned char *)(pMem+ssbase+pReg->_ESP+rol*16+15)
		));
	}
}
