#include "IrpDispatch.h"
#include "VMM/VMMR0.h"
#include "VMM/MDER0.h"


//////////////////////////////////////////////////////////////////////////
// DriverEntry - Entry point of the driver

NTSTATUS DriverEntry(
    __inout PDRIVER_OBJECT  DriverObject,
    __in    PUNICODE_STRING RegistryPath
    )
{    
    NTSTATUS ntStatus = STATUS_SUCCESS;
    UNICODE_STRING  DevKernelName;
  	UNICODE_STRING  DevUserName;
    PDEVICE_OBJECT  DeviceObject = NULL;
	tpMDE pMDE;

	KdPrint(("DriverEntry\n"));
    RtlInitUnicodeString( &DevKernelName, DEVICE_NT_NAME_MAIN );
	//create device
    ntStatus = IoCreateDevice( DriverObject, sizeof(tMDE) , &DevKernelName, 
        FILE_DEVICE_UNKNOWN, FILE_DEVICE_SECURE_OPEN, FALSE, &DeviceObject);
	if (NT_SUCCESS(ntStatus))
	{
		//  Initialize the driver object dispatch table.	
		DriverObject->MajorFunction[IRP_MJ_CREATE] = SSHostMainDriverDispatchCreate;
		DriverObject->MajorFunction[IRP_MJ_CLOSE] = SSHostMainDriverDispatchClose;
		DriverObject->MajorFunction[IRP_MJ_DEVICE_CONTROL] = SSHostMainDriverDeviceControl;
		// Set driver unload routine .
		DriverObject->DriverUnload = SSHostMainDriverUnload;

		// Initialize DeviceObject->DeviceExtension
		pMDE = (tpMDE)(DeviceObject->DeviceExtension);
		memset(pMDE, 0, sizeof(tMDE));
		RtlInitUnicodeString( &DevUserName, DEVICE_WIN32_NAME_MAIN );
		//create symbolic link for our device
		ntStatus = IoCreateSymbolicLink( &DevUserName, &DevKernelName );
		if(!NT_SUCCESS(ntStatus))
			IoDeleteDevice(DeviceObject);
	}
    return ntStatus;
}

//////////////////////////////////////////////////////////////////////////
// Unload routine

VOID SSHostMainDriverUnload(
    __in PDRIVER_OBJECT DriverObject
    )
{
    PDEVICE_OBJECT deviceObject = DriverObject->DeviceObject;
	UNICODE_STRING DevUserName;
	DbgPrint("SSHostDriverUnload\n");
	
    RtlInitUnicodeString(&DevUserName, DEVICE_WIN32_NAME_MAIN);

    IoDeleteSymbolicLink(&DevUserName);

    if (deviceObject != NULL)
    {
        IoDeleteDevice(deviceObject);
	}
}