#include "general.h"
#include "Base/Thread.h"

#ifndef __E
#	define __E(__a)	&(pThread->Events[__a])
#endif

EXERESULT ThrR0Create(tpThread pThread,PVOID pThreadArg){
	EXERESULT rt = SS_SUCCESS;
	OBJECT_ATTRIBUTES ObjAttr;
	HANDLE hThread;
	NTSTATUS ntStatus = STATUS_SUCCESS;
	int t;

	InitializeObjectAttributes(&ObjAttr, NULL, OBJ_KERNEL_HANDLE, NULL, NULL);
	pThread->pThrObj = NULL;
	pThread->ToBeSuspended = FALSE;
	pThread->ToBeTerminated = FALSE;
	pThread->rt = SS_SUCCESS;

	//ʼͨ¼
	for(t = 0 ; t < THREAD_EVENTS_COUNT ; t++)
	{
		KeInitializeEvent(&pThread->Events[t], SynchronizationEvent, FALSE);
	}

	//ʼͨ
	for(t = 0 ; t < THREAD_SPIN_LOCK_COUNT ; t++)
	{
		KeInitializeSpinLock(&pThread->SpinLocks[t]);
	}

	ntStatus = PsCreateSystemThread(
		&hThread,
		(ACCESS_MASK)THREAD_ALL_ACCESS,
		NULL,
		NtCurrentProcess(),
		NULL,
		(PKSTART_ROUTINE)pThread->ThreadEntry,
		pThreadArg
		);
	if(!NT_SUCCESS(ntStatus))
		return SS_THREAD_CREATE_ERROR;
	ntStatus = ObReferenceObjectByHandle(hThread, THREAD_ALL_ACCESS, NULL,KernelMode, &pThread->pThrObj, NULL);
	//ʼָ
	//ʼֹ߳¼
	ZwClose(hThread);
	if(!NT_SUCCESS(ntStatus))
	{
		ThrR0Term(pThread);
		return SS_THREAD_CREATE_ERROR;
	}
	//ȴ߳ȫ
	KeWaitForSingleObject(__E(THREAD_EVENTS_START_SUSS), Executive, KernelMode, FALSE, NULL);
	return rt;
}

/*
 * ֹ߳
 * ô˺ʱ߳̿Ѿ
 */
EXERESULT ThrR0Term(tpThread pThread){
	EXERESULT rt = SS_SUCCESS;
	NTSTATUS ntStatus = STATUS_SUCCESS;

	pThread->ToBeTerminated = TRUE;
	ThrR0OffSuspend(pThread);
	//ȴ߳ȫ
	KeWaitForSingleObject(__E(THREAD_EVENTS_END_SUSS), Executive, KernelMode, FALSE, NULL);
	if(pThread->pThrObj)
	{
		ObDereferenceObject(pThread->pThrObj);
		pThread->pThrObj = NULL;
	}
	if(!NT_SUCCESS(ntStatus))
		rt = SS_THREAD_RELEASE_ERROR;
	return rt;
}
EXERESULT ThrR0SuspendItSel(tpThread pThread){
	EXERESULT rt = SS_SUCCESS;
	KeWaitForSingleObject(__E(THREAD_EVENTS_OFF_SUSPEND), Executive, KernelMode, FALSE, NULL);
	return rt;
}
EXERESULT ThrR0OffSuspend(tpThread pThread){
	EXERESULT rt = SS_SUCCESS;
	pThread->ToBeSuspended = FALSE;
	KeSetEvent(__E(THREAD_EVENTS_OFF_SUSPEND),IO_NO_INCREMENT,FALSE);
	return rt;
}

