#ifndef VMMR0_CYZ_2011_1_13
#define VMMR0_CYZ_2011_1_13

#include "VMM/IntList.h"
#include "VMM/EMR0.h"

typedef struct tVMM{
	bool HasCreated;

	//Interrupt Manage Thread
	tThread IntManageThread;
	KEVENT	IntFetchEvent;
	KEVENT	IntFinishEvent;
	tIntListEntry IntListEntry[INT_LIST_MAX_LENGTH];
	volatile int IntListCount;
	volatile int IntListHead;
	volatile int IntListTail;
	volatile bool IntFetchOpen;		//Ϊtrueⲿж
	KSPIN_LOCK IntListSpinLock;

	//Emulation Manager
	tEM EM;


}tVMM,*tpVMM;

EXERESULT VMMR0Create(tpCVC pCVC);
EXERESULT VMMR0Release(tpCVC pCVC);
EXERESULT VMMR0StartEmu(tpCVC pCVC);
EXERESULT VMMR0CreateIMThread(tpCVC pCVC,tpThread pThread);
EXERESULT VMMR0ReleaseIMThread(tpCVC pCVC,tpThread pThread);

EXERESULT VMMR0FetchExternInterrupt(__in PIRP Irp);
EXERESULT VMMR0CleanUpExternInterrput(tpCVC pCVC);

#ifdef SS_DEBUG
void VMMR0DbgNextCount(tpCVC pCVC,unsigned int count);
#endif

#endif // !defined(VMMR0_CYZ_2011_1_13)