#ifndef _FLAGS_CYZ_2011_2_6
#define _FLAGS_CYZ_2011_2_6

#define FLAG_CN_UNDEFINE		0
//8 bit
#define FLAG_CN_ADC8			1
#define FLAG_CN_ADD8			2
#define FLAG_CN_AND8			3
#define FLAG_CN_CMP8			4
#define FLAG_CN_CMPXCHG8		5
#define FLAG_CN_CMPS8			6
#define FLAG_CN_DEC8			7
#define FLAG_CN_NEG8			8
#define FLAG_CN_OR8				9
#define FLAG_CN_SAL8			10
#define FLAG_CN_SAR8			11
#define FLAG_CN_SBB8			12
#define FLAG_CN_SCAS8			13
#define FLAG_CN_SHL8			14
#define FLAG_CN_SHR8			15
#define FLAG_CN_SUB8			16
#define FLAG_CN_TEST8			17
#define FLAG_CN_XADD8			18
#define FLAG_CN_XOR8			19

//16 bit
#define FLAG_CN_ADC16			20
#define FLAG_CN_ADD16			21
#define FLAG_CN_AND16			22
#define FLAG_CN_CMP16			23
#define FLAG_CN_CMPXCHG16		24		//*
#define FLAG_CN_CMPS16			25
#define FLAG_CN_DEC16			26
#define FLAG_CN_NEG16			27
#define FLAG_CN_OR16			28
#define FLAG_CN_SAL16			29		//*
#define FLAG_CN_SAR16			30		//*
#define FLAG_CN_SBB16			31
#define FLAG_CN_SCAS16			32
#define FLAG_CN_SHL16			33
#define FLAG_CN_SHR16			34
#define FLAG_CN_SUB16			35
#define FLAG_CN_TEST16			36
#define FLAG_CN_XADD16			37
#define FLAG_CN_XOR16			38

//32 bit
#define FLAG_CN_ADC32			39
#define FLAG_CN_ADD32			40
#define FLAG_CN_AND32			41
#define FLAG_CN_CMP32			42
#define FLAG_CN_CMPXCHG32		43
#define FLAG_CN_CMPS32			44
#define FLAG_CN_DEC32			45
#define FLAG_CN_NEG32			46
#define FLAG_CN_OR32			47
#define FLAG_CN_SAL32			48
#define FLAG_CN_SAR32			49
#define FLAG_CN_SBB32			50
#define FLAG_CN_SCAS32			51
#define FLAG_CN_SHL32			52
#define FLAG_CN_SHR32			53
#define FLAG_CN_SUB32			54
#define FLAG_CN_TEST32			55
#define FLAG_CN_XADD32			56
#define FLAG_CN_XOR32			57




//____________________________________EFLAGSĴ___________________________________________
#define		E_CF	0	//Carry Flag (CF)
#define		E_PF	2	//Parity Flag (PF)
#define		E_AF	4	//Auxiliary Carry Flag (AF)
#define		E_ZF	6	//Zero Flag (ZF)
#define		E_SF	7	//Sign Flag (SF)
#define		E_TF	8	//Trap Flag (TF)
#define		E_IF	9	//Interrupt Enable Flag (IF)
#define		E_DF	10	//Direction Flag (DF)
#define		E_OF	11	//Overflow Flag (OF)
#define		E_IOPL	12	//I/O Privilege Level (IOPL)
#define		E_NT	14	//Nested Task (NT)
#define		E_RF	16	//Resume Flag (RF)
#define		E_VM	17	//Virtual-8086 Mode (VM)
#define		E_AC	18	//Alignment Check (AC)
#define		E_VIF	19	//Virtual Interrupt Flag (VIF)
#define		E_VIP	20	//Virtual Interrupt Pending (VIP)
#define		E_ID	21	//ID Flag (ID)

//////use for set////////		or
#define		E_CF_S		0x00000001	//0
#define		E_PF_S		0x00000004	//2
#define		E_AF_S		0x00000010	//4
#define		E_ZF_S		0x00000040	//6
#define		E_SF_S		0x00000080	//7
#define		E_TF_S		0x00000100	//8
#define		E_IF_S		0x00000200	//9
#define		E_DF_S		0x00000400	//10
#define		E_OF_S		0x00000800	//11
#define		E_IOPL_S	0x00001000	//12
#define		E_NT_S		0x00004000	//14
#define		E_RF_S		0x00010000	//16
#define		E_VM_S		0x00020000	//17
#define		E_AC_S		0x00040000	//18
#define		E_VIF_S		0x00080000	//19
#define		E_VIP_S		0x00100000	//20
#define		E_ID_S		0x00200000	//21
//////use for clear//////		and
#define		E_CF_C		0xFFFFFFFF-E_CF_S		//0
#define		E_PF_C		0xFFFFFFFF-E_PF_S		//2
#define		E_AF_C		0xFFFFFFFF-E_AF_S		//4
#define		E_ZF_C		0xFFFFFFFF-E_ZF_S		//6
#define		E_SF_C		0xFFFFFFFF-E_SF_S		//7
#define		E_TF_C		0xFFFFFFFF-E_TF_S		//8
#define		E_IF_C		0xFFFFFFFF-E_IF_S		//9
#define		E_DF_C		0xFFFFFFFF-E_DF_S		//10
#define		E_OF_C		0xFFFFFFFF-E_OF_S		//11
#define		E_IOPL_C	0xFFFFFFFF-E_IOPL_S		//12
#define		E_NT_C		0xFFFFFFFF-E_NT_S		//14
#define		E_RF_C		0xFFFFFFFF-E_RF_S		//16
#define		E_VM_C		0xFFFFFFFF-E_VM_S		//17
#define		E_AC_C		0xFFFFFFFF-E_AC_S		//18
#define		E_VIF_C		0xFFFFFFFF-E_VIF_S		//19
#define		E_VIP_C		0xFFFFFFFF-E_VIP_S		//20
#define		E_ID_C		0xFFFFFFFF-E_ID_S		//21



#define	FLAG_OFFSET_OF		5
#define	FLAG_OFFSET_SF		4
#define	FLAG_OFFSET_ZF		3
#define	FLAG_OFFSET_AF		2
#define	FLAG_OFFSET_PF		1
#define	FLAG_OFFSET_CF		0

typedef struct tFlags{
	unsigned short CurFlagOpCodeName;
	unsigned char HasGetted;				//ָֻINC  DEC Ϊ1
	unsigned char PreCF;					//ֻҪǰһCF־ָжд: ADC
	union{
		unsigned char u8;
		signed char	s8;
		unsigned short u16;
		signed short s16;
		unsigned int u32;
		signed int s32;
	}op1;
	union{
		unsigned char u8;
		signed char	s8;
		unsigned short u16;
		signed short s16;
		unsigned int u32;
		signed int s32;
	}op2;
	union{
		unsigned char u8;
		signed char	s8;
		unsigned short u16;
		signed short s16;
		unsigned int u32;
		signed int s32;
	}res;
}tFlags,*tpFlags;

extern const bool parity_lookup[256];

//--------------------------Delay_Get_Flag-------------------------
static __inline void Delay_Get_Flag_8(tpFlags pFlagsAbout,
	unsigned char op1_u8,
	unsigned char op2_u8,
	unsigned char res_u8,
	unsigned short FlagOpCodeName,
	unsigned char HasGettedCF
	)
{
	pFlagsAbout->op1.u8 = op1_u8;
	pFlagsAbout->op2.u8 = op2_u8;
	pFlagsAbout->res.u8 = res_u8;
	pFlagsAbout->HasGetted = HasGettedCF;
	pFlagsAbout->CurFlagOpCodeName = FlagOpCodeName;
}

static __inline void Delay_Get_Flag_16(tpFlags pFlagsAbout,
	unsigned short op1_u16,
	unsigned short op2_u16,
	unsigned short res_u16,
	unsigned short FlagOpCodeName,
	unsigned char HasGettedCF
	)
{
	pFlagsAbout->op1.u16 = op1_u16;
	pFlagsAbout->op2.u16 = op2_u16;
	pFlagsAbout->res.u16 = res_u16;
	pFlagsAbout->HasGetted = HasGettedCF;
	pFlagsAbout->CurFlagOpCodeName = FlagOpCodeName;
}

static __inline void Delay_Get_Flag_32(tpFlags pFlagsAbout,
	unsigned int op1_u32,
	unsigned int op2_u32,
	unsigned int res_u32,
	unsigned short FlagOpCodeName,
	unsigned char HasGettedCF
	)
{
	pFlagsAbout->op1.u32 = op1_u32;
	pFlagsAbout->op2.u32 = op2_u32;
	pFlagsAbout->res.u32 = res_u32;
	pFlagsAbout->HasGetted = HasGettedCF;
	pFlagsAbout->CurFlagOpCodeName = FlagOpCodeName;
}


//--------------------Delay_Get_Flag_With_PreCF---------------------
static __inline void Delay_Get_Flag_With_PreCF_8(tpFlags pFlagsAbout,
	unsigned char op1_u8,
	unsigned char op2_u8,
	unsigned char res_u8,
	unsigned short FlagOpCodeName,
	unsigned char HasGettedCF,
	unsigned char PreCF
	)
{
	pFlagsAbout->op1.u8 = op1_u8;
	pFlagsAbout->op2.u8 = op2_u8;
	pFlagsAbout->res.u8 = res_u8;
	pFlagsAbout->HasGetted = HasGettedCF;
	pFlagsAbout->PreCF = PreCF;
	pFlagsAbout->CurFlagOpCodeName = FlagOpCodeName;
}

static __inline void Delay_Get_Flag_With_PreCF_16(tpFlags pFlagsAbout,
	unsigned short op1_u16,
	unsigned short op2_u16,
	unsigned short res_u16,
	unsigned short FlagOpCodeName,
	unsigned char HasGettedCF,
	unsigned char PreCF
	)
{
	pFlagsAbout->op1.u16 = op1_u16;
	pFlagsAbout->op2.u16 = op2_u16;
	pFlagsAbout->res.u16 = res_u16;
	pFlagsAbout->HasGetted = HasGettedCF;
	pFlagsAbout->PreCF = PreCF;
	pFlagsAbout->CurFlagOpCodeName = FlagOpCodeName;
}

static __inline void Delay_Get_Flag_With_PreCF_32(tpFlags pFlagsAbout,
	unsigned int op1_u32,
	unsigned int op2_u32,
	unsigned int res_u32,
	unsigned short FlagOpCodeName,
	unsigned char HasGettedCF,
	unsigned char PreCF
	)
{
	pFlagsAbout->op1.u32 = op1_u32;
	pFlagsAbout->op2.u32 = op2_u32;
	pFlagsAbout->res.u32 = res_u32;
	pFlagsAbout->HasGetted = HasGettedCF;
	pFlagsAbout->PreCF = PreCF;
	pFlagsAbout->CurFlagOpCodeName = FlagOpCodeName;
}


bool FlagsGetOFByFlagAb(tpFlags pFlagsAbout,unsigned int * pEFlags);
bool FlagsGetSFByFlagAb(tpFlags pFlagsAbout,unsigned int * pEFlags);
bool FlagsGetZFByFlagAb(tpFlags pFlagsAbout,unsigned int * pEFlags);
bool FlagsGetAFByFlagAb(tpFlags pFlagsAbout,unsigned int * pEFlags);
bool FlagsGetPFByFlagAb(tpFlags pFlagsAbout,unsigned int * pEFlags);
bool FlagsGetCFByFlagAb(tpFlags pFlagsAbout,unsigned int * pEFlags);

void FlagsGetAllByFlagAb(tpFlags pFlagsAbout,unsigned int * pEFlags);
//#################### Set Flags ##################
//.................OF SF ZF AF PF CF...............
//κʱ޸OF SF ZF AF PF CFֵʱҪͬʱ޸tFlags еHasGetted
static __inline void FlagsSet_OF_CF(unsigned int * pFlags,tpFlags pFlagsAbout,unsigned char C_of,unsigned char C_cf){
	(*pFlags) &= (E_OF_C & E_CF_C);
	(*pFlags) |= ((!!C_of) << E_OF) | ((!!C_cf) << E_CF);
	pFlagsAbout->HasGetted |= (0x01 << FLAG_OFFSET_OF) | (0x01 << FLAG_OFFSET_CF);
}

//6Ҫ
static __inline void FlagsSet_OF(unsigned int * pFlags,tpFlags pFlagsAbout,unsigned char C_of){
	(*pFlags) &= E_OF_C;
	(*pFlags) |= ((!!C_of) << E_OF);
	pFlagsAbout->HasGetted |= (0x01 << FLAG_OFFSET_OF);
}

static __inline void FlagsSet_SF(unsigned int * pFlags,tpFlags pFlagsAbout,unsigned char C_sf){
	(*pFlags) &= E_SF_C;
	(*pFlags) |= ((!!C_sf) << E_SF);
	pFlagsAbout->HasGetted |= (0x01 << FLAG_OFFSET_SF);
}

static __inline void FlagsSet_ZF(unsigned int * pFlags,tpFlags pFlagsAbout,unsigned char C_zf){
	(*pFlags) &= E_ZF_C;
	(*pFlags) |= ((!!C_zf) << E_ZF);
	pFlagsAbout->HasGetted |= (0x01 << FLAG_OFFSET_ZF);
}

static __inline void FlagsSet_AF(unsigned int * pFlags,tpFlags pFlagsAbout,unsigned char C_af){
	(*pFlags) &= E_AF_C;
	(*pFlags) |= ((!!C_af) << E_AF);
	pFlagsAbout->HasGetted |= (0x01 << FLAG_OFFSET_AF);
}

//PF һ㲻ͬ
static __inline void FlagsSet_PF(unsigned int * pFlags,tpFlags pFlagsAbout,unsigned char value){
	bool b;
	b = parity_lookup[value];
	(*pFlags) &= E_PF_C;
	(*pFlags) |= (b << E_PF);
	pFlagsAbout->HasGetted |= (0x01 << FLAG_OFFSET_PF);
}

static __inline void FlagsSet_CF(unsigned int * pFlags,tpFlags pFlagsAbout,unsigned char C_cf){
	(*pFlags) &= E_CF_C;
	(*pFlags) |= ((!!C_cf) << E_CF);
	pFlagsAbout->HasGetted |= (0x01 << FLAG_OFFSET_CF);
}

//....................  ........................
//set ĬΪ1
//IF
static __inline void FlagsSet_IF(unsigned int * pFlags){
	*pFlags |= E_IF_S;
}

//DF
static __inline void FlagsSet_DF(unsigned int * pFlags){
	*pFlags |= E_DF_S;
}
//################# Clear Flags ###################
//2Ҫ

static __inline void FlagsClearDF(unsigned int * pFlags){
	*pFlags = (*pFlags) & E_DF_C;
}

static __inline void FlagsClearIF(unsigned int * pFlags){
	*pFlags = (*pFlags) & E_IF_C;
}

static __inline void FlagsClearTF(unsigned int * pFlags){
	*pFlags = (*pFlags) & E_TF_C;
}

static __inline void FlagsClearAC(unsigned int * pFlags){
	*pFlags = (*pFlags) & E_AC_C;
}
//############### Get Flags Normal ################
static bool __inline FlagsGetDF(unsigned int * pFlags){
	return ((*pFlags)>>E_DF) & 0x01;
}

static bool __inline FlagsGetIF(unsigned int * pFlags){
	return ((*pFlags)>>E_IF) & 0x01;
}

#endif // !defined(_FLAGS_CYZ_2011_2_6)