#ifndef MEMACCESS_CYZ_2011_2_7
#define MEMACCESS_CYZ_2011_2_7

#include "VMM/Emulator/Emulator.h"

//------------------Write directly--------------------
static __inline void WritePhyMemDirectly_8(tpEmulator pEm,unsigned int offset,unsigned char value){
	*(unsigned char *)(pEm->pGPM+offset)= value;
}
static __inline void WritePhyMemDirectly_16(tpEmulator pEm,unsigned int offset,unsigned short value){
	*(unsigned short *)(pEm->pGPM+offset) = value;
}
static __inline void WritePhyMemDirectly_32(tpEmulator pEm,unsigned int offset,unsigned int value){
	*(unsigned int *)(pEm->pGPM+offset) = value;
}

//------------------Read directly--------------------
static __inline unsigned char ReadPhyMemDirectly_8(tpEmulator pEm,unsigned int offset){
	return *(unsigned char *)(pEm->pGPM+offset);
}

static __inline unsigned short ReadPhyMemDirectly_16(tpEmulator pEm,unsigned int offset){
	return *(unsigned short *)(pEm->pGPM+offset);
}

static __inline unsigned int ReadPhyMemDirectly_32(tpEmulator pEm,unsigned int offset){
	return *(unsigned int *)(pEm->pGPM+offset);
}





void MemWrite_0_8(tpEmulator pEm , int SegmentType , unsigned int offset ,unsigned char value);
void MemWrite_1_8(tpEmulator pEm , int SegmentType , unsigned short offset ,unsigned char value);
void MemWrite_0_16(tpEmulator pEm , int SegmentType , unsigned int offset ,unsigned short value);
void MemWrite_1_16(tpEmulator pEm , int SegmentType , unsigned short offset ,unsigned short value);
void MemWrite_0_32(tpEmulator pEm , int SegmentType , unsigned int offset ,unsigned int value);
void MemWrite_1_32(tpEmulator pEm , int SegmentType , unsigned short offset ,unsigned int value);

unsigned char MemRead_0_8(tpEmulator pEm , int SegmentType , unsigned int offset);
unsigned char MemRead_1_8(tpEmulator pEm , int SegmentType , unsigned short offset);
unsigned short MemRead_0_16(tpEmulator pEm , int SegmentType , unsigned int offset);
unsigned short MemRead_1_16(tpEmulator pEm , int SegmentType , unsigned short offset);
unsigned int MemRead_0_32(tpEmulator pEm , int SegmentType , unsigned int offset);
unsigned int MemRead_1_32(tpEmulator pEm , int SegmentType , unsigned short offset);

#endif // !defined(MEMACCESS_CYZ_2011_2_7)