#ifndef EMULATOR_CYZ_2011_1_31
#define EMULATOR_CYZ_2011_1_31

#include "VMM/CVCR0.h"
#include "VMM/CPUMR0.h"
#include "VMM/Emulator/_Flags.h"

#define	LARGEST_INSTRUCTION_LEN			16		//ָ		

//_______________________________________CPUģʽ_______________________________________________
#define	CPU_MODE_NUM			5	//The number of mode
#define	PROTECTED_MODE			0	//Protected mode
#define REAL_ADDRESS_MODE		1	//Real-address mode
#define SYSTEM_MANAGEMENT_MODE	2	//System management mode (SMM)
#define VIRTUAL_8086_MODE		3	//Virtual-8086 mode
#define IA_32E_MODE				4	//IA-32e mode



//________________________________ModrmеrλӦĶμĴ__________________________________
#define		SS_SEGMENT_COUNT		6
#define		SS_SEGMENT_ES			0
#define		SS_SEGMENT_CS			1
#define		SS_SEGMENT_SS			2
#define		SS_SEGMENT_DS			3
#define		SS_SEGMENT_FS			4
#define		SS_SEGMENT_GS			5
#define		SS_SEGMENT_UNDEFINED	6

//__________________________________tInstruction prefix___________________________________
//group 1
#define			PREFIX_GROUP1_CLEAR		0xFFF0
#define			PREFIX_G1_F0			0x01
#define			PREFIX_G1_F2			0x02
#define			PREFIX_G1_F3			0x03
//group 2
#define			PREFIX_GROUP2_CLEAR		0xFF0F
#define			PREFIX_G2_2E			0x0010
#define			PREFIX_G2_36			0x0020
#define			PREFIX_G2_3E			0x0030
#define			PREFIX_G2_26			0x0040
#define			PREFIX_G2_64			0x0050
#define			PREFIX_G2_65			0x0060
//group 3
#define			PREFIX_GROUP3_CLEAR		0xF0FF
#define			PREFIX_G3_66			0x0100
//group 4
#define			PREFIX_GROUP4_CLEAR		0x0FFF
#define			PREFIX_G4_67			0x1000


//Чж(쳣)
#ifndef EOI_NONE
#  define	EOI_NONE			-1
#endif

typedef struct tEmulator;
typedef struct tEmulator *tpEmulator;

typedef struct tInstruction{
	void  ( * ExecuteFun)(tpEmulator pEmulator);
	unsigned short len;
	unsigned char mod;
	unsigned char rm;
	unsigned char r;	//Modrmеrλ, Ĵ
	unsigned char sreg;
	PVOID pi;
	unsigned int prefix_g1;

	union{
		unsigned char * up8;
		unsigned short * up16;
		unsigned int  * up32;
		unsigned char u8;
		unsigned short u16;
		unsigned int u32;
	}_Rmv;		//ֵΪĴֵַеƫƣGetֱӷصַ)

	union{
		signed int s32;
		unsigned int u32;
		signed short s16;
		unsigned short u16;
		signed char s8;
		unsigned char u8;
	}argu1;
	union{
		signed int s32;
		unsigned int u32;
		signed short s16;
		unsigned short u16;
		signed char s8;
		unsigned char u8;
	}argu2;
	union{
		signed int s32;
		unsigned int u32;
		signed short s16;
		unsigned short u16;
		signed char s8;
		unsigned char u8;
	}argu3;
}tInstruction , *tpInstruction;

typedef struct tModrmArray{
	//--------r----------
	unsigned char * r_8[8];
	unsigned short * r_16[8];
	unsigned int * r_32[8];

	//-------r/m---------
	//	#16#
	//mod == 0
	unsigned short * rm_mod0_16[8][2];
	//mod == 1 or mod == 2
	unsigned short * rm_mod1o2_16[8][2];
	//mod == 3
	unsigned char * rm_mod3_8[8];
	unsigned short * rm_mod3_16[8];
	unsigned int * rm_mod3_32[8];

	//  #32#
	//mod == 0
	//mod == 1
	//mod == 2
	//mod == 3	16λͬ

	//---------Sreg----------
	//ֻ16λ
	tSegment * sreg_16[SS_SEGMENT_COUNT];

}tModrmArray,*tpModrmArray;
typedef struct tEmulator{
	tpCVC  pCVC;
	int CpuID;

	tpReg  pReg;
	tInstruction Instr;
	//ModRM
	tModrmArray ModrmA;
	tFlags	FlagsAbout;
	int CpuMode;
	//Segment Descriptor еD/Bλ;
	bool SD_FLAG_DB;
	//Guest Physical Memory	Ӧڴ׵ַ
	char * pGPM;
	//Current Instruction Start еһַ
	unsigned char * pCIS;
	//ǰȡָָ
	bool (* CurGetIns)(PVOID pEmulator);
	//ǰָָ
	bool (* CurRunIns)(PVOID pEmulator);
}tEmulator,*tpEmulator;

EXERESULT EmulatorCreate(tpEmulator * ppEmulator);
EXERESULT EmulatorInit(tpEmulator pEmulator,tpCVC pCVC , int ThreadID);
EXERESULT EmulatorRelease(tpEmulator pEmulator);
EXERESULT EmulateOneInstr(tpEmulator pEmulator);
EXERESULT EmulateABlockOfInstr(tpEmulator pEmulator);
EXERESULT EmulatorInitModRMTable(tpEmulator pEmulator);
EXERESULT EmulatorInitGlobalFunPoint();
EXERESULT EmulatorInitGlobalSubTable();

#endif // !defined(EMULATOR_CYZ_2011_1_31)