#ifndef EMUDATA_CYZ_2011_1_31
#define EMUDATA_CYZ_2011_1_31


#include "VMM/Emulator/Emulator.h"

//___________________________________DATA OR ADDRESS SIZE_______________________________________
#define		OPRAND_SIZE_NUM			2
#define		OPRAND16				0
#define		OPRAND32				1

#define		ADDRESS_SIZE_NUM		2
#define		ADDRESS16				0
#define		ADDRESS32				1

//__________________________________INSTRUCTION ATTRIBUTE_________________________________________
#define IA_NONE		0x0000
#define IA_REP		0x0001
#define IA_REPZ		0x0002
#define IA_LOCK		0x0004

#define	START_MEM_ADDRESS_FOR_BOOTING	0x7C00

extern bool (* GetIns[CPU_MODE_NUM][OPRAND_SIZE_NUM][ADDRESS_SIZE_NUM])(PVOID pEmulator);		//ȡָָ
extern bool (* RunIns[CPU_MODE_NUM])(PVOID pEmulator);		//

typedef struct tagIntelAsmInstruction * pIais;

typedef struct tagIntelAsmInstruction
{
	int		Opcode;				//
	char *	Instruction;		//
	unsigned short CodeName;	//
	unsigned short Attr;
	pIais	subtable;
	void	( *	DeCompile_0_16_16)(tpEmulator pEmulator);	//	ģʽ		16λ		16λַģʽ
	void	( * ExecuteFun_0_16_16)(tpEmulator pEmulator);	//ִк	ģʽ		16λ		16λַģʽ
	void	( *	DeCompile_0_32_16)(tpEmulator pEmulator);	//	ģʽ		32λ		16λַģʽ
	void	( * ExecuteFun_0_32_16)(tpEmulator pEmulator);	//ִк	ģʽ		32λ		16λַģʽ
	void	( *	DeCompile_1_16_16)(tpEmulator pEmulator);	//	ʵַģʽ	16λ		16λַģʽ
	void	( * ExecuteFun_1_16_16)(tpEmulator pEmulator);	//ִк	ʵַģʽ	16λ		16λַģʽ
	void	( *	DeCompile_1_32_16)(tpEmulator pEmulator);	//	ʵַģʽ	32λ		16λַģʽ
	void	( * ExecuteFun_1_32_16)(tpEmulator pEmulator);	//ִк	ʵַģʽ	32λ		16λַģʽ

	void	( *	DeCompile_0_16_32)(tpEmulator pEmulator);	//	ģʽ		16λ		32λַģʽ
	void	( * ExecuteFun_0_16_32)(tpEmulator pEmulator);	//ִк	ģʽ		16λ		32λַģʽ
	void	( *	DeCompile_0_32_32)(tpEmulator pEmulator);	//	ģʽ		32λ		32λַģʽ
	void	( * ExecuteFun_0_32_32)(tpEmulator pEmulator);	//ִк	ģʽ		32λ		32λַģʽ
	void	( *	DeCompile_1_16_32)(tpEmulator pEmulator);	//	ʵַģʽ	16λ		32λַģʽ
	void	( * ExecuteFun_1_16_32)(tpEmulator pEmulator);	//ִк	ʵַģʽ	16λ		32λַģʽ
	void	( *	DeCompile_1_32_32)(tpEmulator pEmulator);	//	ʵַģʽ	32λ		32λַģʽ
	void	( * ExecuteFun_1_32_32)(tpEmulator pEmulator);	//ִк	ʵַģʽ	32λ		32λַģʽ
}Iais,*pIais;

//################ַ###################
extern Iais InstrAbout[];

extern Iais InstrSubTable_OF[256];
extern Iais InstrSubTable_OF_00[8];
extern Iais InstrSubTable_OF_01[8];
extern Iais InstrSubTable_OF_18[8];
extern Iais InstrSubTable_OF_71[8];
extern Iais InstrSubTable_OF_72[8];
extern Iais InstrSubTable_OF_73[8];
extern Iais InstrSubTable_OF_AE[8];
extern Iais InstrSubTable_OF_BA[8];
extern Iais InstrSubTable_OF_CF[8];

extern Iais InstrSubTable_80[8];
extern Iais InstrSubTable_81[8];
extern Iais InstrSubTable_82[8];
extern Iais InstrSubTable_83[8];
extern Iais InstrSubTable_C0[8];
extern Iais InstrSubTable_C1[8];
extern Iais InstrSubTable_D0[8];
extern Iais InstrSubTable_D1[8];
extern Iais InstrSubTable_D2[8];
extern Iais InstrSubTable_D3[8];
extern Iais InstrSubTable_D8[8];
extern Iais InstrSubTable_D9[8];
extern Iais InstrSubTable_DA[8];
extern Iais InstrSubTable_DB[8];
extern Iais InstrSubTable_DC[8];
extern Iais InstrSubTable_DD[8];
extern Iais InstrSubTable_DE[8];
extern Iais InstrSubTable_DF[8];
extern Iais InstrSubTable_F6[8];
extern Iais InstrSubTable_F7[8];
extern Iais InstrSubTable_FE[8];
extern Iais InstrSubTable_FF[8];

#endif // !defined(EMUDATA_CYZ_2011_1_31)