#ifndef _FATCHRM_CYZ_2011_2_5
#define _FATCHRM_CYZ_2011_2_5

#include "general.h"
#include "VMM/Emulator/Emulator.h"

static const char Sreg_mod0_16[8] ={SS_SEGMENT_DS,SS_SEGMENT_DS,SS_SEGMENT_SS,SS_SEGMENT_SS,SS_SEGMENT_DS,SS_SEGMENT_DS,SS_SEGMENT_DS,SS_SEGMENT_DS};
static const char Sreg_mod1_16[8] = {SS_SEGMENT_DS,SS_SEGMENT_DS,SS_SEGMENT_SS,SS_SEGMENT_SS,SS_SEGMENT_DS,SS_SEGMENT_DS,SS_SEGMENT_SS,SS_SEGMENT_DS};
static const char Sreg_mod2_16[8] = {SS_SEGMENT_DS,SS_SEGMENT_DS,SS_SEGMENT_SS,SS_SEGMENT_SS,SS_SEGMENT_DS,SS_SEGMENT_DS,SS_SEGMENT_SS,SS_SEGMENT_DS};

static const char Sreg_mod0_32[8];
static const char Sreg_mod1_32[8];
static const char Sreg_mod2_32[8];
//ԤȻRMϢd_...() ִУ磺d_1_16_XOR_r16_rm16
static void PreFatchRM_0_16(tpEmulator pEm){
	KdPrint(("PreFatchRM_0_16δģ\n"));
}

//1: ʵַģʽ	1616λַģʽ
static void PreFatchRM_1_16(tpEmulator pEm){
	//ǰpEm->pCIS ָ Modrm λ ڱڲܸıֵ
	//mod == 0 || mod == 1 || mod == 2	ʱrmֵƫƵַ
	//mod == 3 ʱrmӦļĴĵַ

	switch(pEm->Instr.mod){
	case 0:
		if(pEm->Instr.sreg == SS_SEGMENT_UNDEFINED)
			pEm->Instr.sreg = Sreg_mod0_16[pEm->Instr.rm];
		if(pEm->Instr.rm != 6)
		{
			pEm->Instr.len++;
			pEm->Instr.argu1.s16 = 0;
		}
		else
		{
			pEm->Instr.len += 3;
			pEm->Instr.argu1.s16 = *(signed short *)(pEm->pCIS+1);
		}
		break;
	case 1:
		if(pEm->Instr.sreg == SS_SEGMENT_UNDEFINED)
			pEm->Instr.sreg = Sreg_mod1_16[pEm->Instr.rm];
		pEm->Instr.len += 2;
		pEm->Instr.argu1.s16 = *(signed char *)(pEm->pCIS+1);
		break;
	case 2:
		if(pEm->Instr.sreg == SS_SEGMENT_UNDEFINED)
			pEm->Instr.sreg = Sreg_mod2_16[pEm->Instr.rm];
		pEm->Instr.len += 3;
		pEm->Instr.argu1.s16 = *(signed short *)(pEm->pCIS+1);
		break;
	case 3:
		pEm->Instr.len++;
		break;
	}
}

static void PreFatchRM_0_32(tpEmulator pEm){
	KdPrint(("PreFatchRM_0_32δģ\n"));
}

static void PreFatchRM_1_32(tpEmulator pEm){
	KdPrint(("PreFatchRM_1_32δģ\n"));
}

//RMϢe_...() ִУ磺e_1_16_XOR_r16_rm16
static void FatchRM_0_16(tpEmulator pEm){
	KdPrint(("FatchRM_0_16δģ\n"));
}

//1: real mode 16: address size
static void FatchRM_1_16(tpEmulator pEm){
	switch(pEm->Instr.mod){
	case 0:
		pEm->Instr._Rmv.u16 = *(pEm->ModrmA.rm_mod0_16[pEm->Instr.rm][0])+
													*(pEm->ModrmA.rm_mod0_16[pEm->Instr.rm][1])+
													pEm->Instr.argu1.s16;
		break;
	case 1:
		pEm->Instr._Rmv.u16 = *(pEm->ModrmA.rm_mod1o2_16[pEm->Instr.rm][0])+
													*(pEm->ModrmA.rm_mod1o2_16[pEm->Instr.rm][1])+
													pEm->Instr.argu1.s16;
		break;
	case 2:
		pEm->Instr._Rmv.u16 = *(pEm->ModrmA.rm_mod1o2_16[pEm->Instr.rm][0])+
													*(pEm->ModrmA.rm_mod1o2_16[pEm->Instr.rm][1])+
													pEm->Instr.argu1.s16;
		break;
	case 3:
		//˴ΪգRMϢ PreFatchRM ȫȡ
		break;
	}
}

static void FatchRM_0_32(tpEmulator pEm){
	KdPrint(("FatchRM_0_32δģ\n"));
}

static void FatchRM_1_32(tpEmulator pEm){
	KdPrint(("FatchRM_1_32δģ\n"));
}

#endif // !defined(_FATCHRM_CYZ_2011_2_5)