#ifndef _DEFINE_CYZ_2011_2_5
#define _DEFINE_CYZ_2011_2_5

#include "general.h"
#include "VMM/Emulator/Emulator.h"
#include "VMM/Emulator/EmuData.h"
#include "VMM/Emulator/_Flags.h"
#include "VMM/Emulator/ExcepOrInterr.h"
#include "VMM/Emulator/MemAccess.h"
#include "VMM/Emulator/A2ZH/_FatchRM.h"

//1: real mode 16: Operand size 16: Address size
static __inline void LinkExeFunToInstr_1_16_16(tpEmulator pEm){
	pEm->Instr.ExecuteFun = InstrAbout[*(pEm->pCIS)].ExecuteFun_1_16_16;
}

//1: real mode 32: Operand size 16: Address size
static __inline void LinkExeFunToInstr_1_32_16(tpEmulator pEm){
	pEm->Instr.ExecuteFun = InstrAbout[*(pEm->pCIS)].ExecuteFun_1_32_16;
}
//1: real mode 16: data size
//move Eip to Next contigeous Instruction
static __inline void MoveEipToNextContInstr_1_16(tpEmulator pEm){
	pEm->pReg->_IP +=pEm->Instr.len;
}
//################################################################
//############################  r  ###############################
//################################################################

//----------------GetModrm_r_value-----------------
static __inline unsigned char GetModrm_r_value_8(tpEmulator pEm){
	return *(pEm->ModrmA.r_8[pEm->Instr.r]);
}

static __inline unsigned short GetModrm_r_value_16(tpEmulator pEm){
	return *(pEm->ModrmA.r_16[pEm->Instr.r]);
}

static __inline unsigned int GetModrm_r_value_32(tpEmulator pEm){
	return *(pEm->ModrmA.r_32[pEm->Instr.r]);
}

//----------------SetModrm_r_value-----------------
static __inline void SetModrm_r_value_8(tpEmulator pEm,unsigned char value){
	*(pEm->ModrmA.r_8[pEm->Instr.r]) = value;
}

static __inline void SetModrm_r_value_16(tpEmulator pEm,unsigned short value){
	*(pEm->ModrmA.r_16[pEm->Instr.r]) = value;
}

static __inline void SetModrm_r_value32(tpEmulator pEm,unsigned int value){
	*(pEm->ModrmA.r_32[pEm->Instr.r]) = value;
}
//################################################################
//##########################  sreg  ##############################
//################################################################

//----------------GetModrm_sreg_value-----------------
static __inline unsigned short GetModrm_sreg_value_16(tpEmulator pEm){
	return pEm->ModrmA.sreg_16[pEm->Instr.r]->v;
}

//----------------SetModrm_sreg_value-----------------
static __inline void SetModrm_sreg_value_16(tpEmulator pEm,unsigned short value){
#ifdef SS_RUN_STRICT
	if(pEm->Instr.r>=SS_SEGMENT_COUNT)
	{
		InvalidOpcode_1(pEm);
	}
#endif
	pEm->ModrmA.sreg_16[pEm->Instr.r]->v = value;
	pEm->ModrmA.sreg_16[pEm->Instr.r]->h.Base = value *16;
}

//################################################################
//############################  rm  ##############################
//################################################################
//----------------GetModrm_rm_value-----------------
static __inline unsigned char GetModrm_rm_value_0_8(tpEmulator pEm){
	KdPrint(("GetModrm_rm_value_0_8δģ\n"));
	if(pEm->Instr.mod == 3)
		return *(pEm->ModrmA.rm_mod3_8[pEm->Instr.rm]);
	else
	{
	}
}

static __inline unsigned char GetModrm_rm_value_1_8(tpEmulator pEm){
	if(pEm->Instr.mod == 3)
		return *(pEm->ModrmA.rm_mod3_8[pEm->Instr.rm]);
	else
	{
		return MemRead_1_8(pEm , pEm->Instr.sreg , pEm->Instr._Rmv.u16);	//ʵַģʽƫƵַΪ16λ
	}
}

static __inline unsigned short GetModrm_rm_value_0_16(tpEmulator pEm){
	KdPrint(("GetModrm_rm_value_0_16δģ\n"));
	if(pEm->Instr.mod == 3)
		return *(pEm->ModrmA.rm_mod3_16[pEm->Instr.rm]);
	else
	{
	}
}
//1: real mode 16: value size
static __inline unsigned short GetModrm_rm_value_1_16(tpEmulator pEm){
	if(pEm->Instr.mod == 3)
		return *(pEm->ModrmA.rm_mod3_16[pEm->Instr.rm]);
	else
	{
		return MemRead_1_16(pEm , pEm->Instr.sreg , pEm->Instr._Rmv.u16);
	}
}

static __inline unsigned int GetModrm_rm_value_0_32(tpEmulator pEm){
	KdPrint(("GetModrm_rm_value_0_32δģ\n"));
	if(pEm->Instr.mod == 3)
		return *(pEm->ModrmA.rm_mod3_32[pEm->Instr.rm]);
	else
	{
	}
}

static __inline unsigned int GetModrm_rm_value_1_32(tpEmulator pEm){
	KdPrint(("GetModrm_rm_value_1_32δģ\n"));
	if(pEm->Instr.mod == 3)
		return *(pEm->ModrmA.rm_mod3_32[pEm->Instr.rm]);
	else
	{
		return MemRead_1_32(pEm , pEm->Instr.sreg , pEm->Instr._Rmv.u32);
	}
}

//----------------SetModrm_rm_value-----------------
static __inline void SetModrm_rm_value_0_8(tpEmulator pEm, unsigned char value){
	KdPrint(("SetModrm_rm_value_0_8δģ\n"));
}
static __inline void SetModrm_rm_value_1_8(tpEmulator pEm, unsigned char value){
	if(pEm->Instr.mod == 3)
		*(pEm->ModrmA.rm_mod3_8[pEm->Instr.rm]) = value;
	else
	{
		MemWrite_1_8(pEm , pEm->Instr.sreg , pEm->Instr._Rmv.u16 , value);	//ʵַģʽƫƵַΪ16λ
	}
}
static __inline void SetModrm_rm_value_1_16(tpEmulator pEm, unsigned short value){
	if(pEm->Instr.mod == 3)
		*(pEm->ModrmA.rm_mod3_16[pEm->Instr.rm]) = value;
	else
	{
		MemWrite_1_16(pEm , pEm->Instr.sreg , pEm->Instr._Rmv.u16 , value);
	}
}
//################################################################
//##########################  stack  #############################
//################################################################
//---------------------Push2Stack-------------------
static __inline void Push2Stack_0_16(tpEmulator pEm,unsigned short value){
	KdPrint(("Push2Stack_0_16δģ\n"));
}

//1: real mode 16: data size
static __inline void Push2Stack_1_16(tpEmulator pEm,unsigned short value){
#ifdef SS_RUN_STRICT
	if(pEm->pReg->_SP == 1)
	{
		//the processor generates a #DF exception and enters a shutdown state
		Fatal_Err_1(pEm,"PUSH гESP == 1\n");
	}
#endif
	pEm->pReg->_SP -= 2;
	MemWrite_1_16(pEm , SS_SEGMENT_SS , pEm->pReg->_SP , value);
}
static __inline void Push2Stack_0_32(tpEmulator pEm,unsigned int value){
	KdPrint(("Push2Stack_0_32δģ\n"));
}

static __inline void Push2Stack_1_32(tpEmulator pEm,unsigned int value){
#ifdef SS_RUN_STRICT
	if(pEm->pReg->_ESP >= 1 && pEm->pReg->_ESP <= 3)
	{
		//the processor generates a #DF exception and enters a shutdown state
		Fatal_Err_1(pEm,"PUSH гESP == 1\n");
	}
#endif
	pEm->pReg->_ESP -= 4;
	MemWrite_1_32(pEm , SS_SEGMENT_SS , pEm->pReg->_ESP , value);
}


//--------------------PopFromStack------------------
static __inline unsigned short PopFromStack_0_16(tpEmulator pEm){
	KdPrint(("PopFromStack_0_16δģ\n"));
}

static __inline unsigned short PopFromStack_1_16(tpEmulator pEm){
	unsigned short value;
	value = MemRead_1_16(pEm , SS_SEGMENT_SS , pEm->pReg->_SP);
	pEm->pReg->_SP += 2;
	return value;
}

static __inline unsigned int PopFromStack_0_32(tpEmulator pEm){
	KdPrint(("PopFromStack_0_32δģ\n"));
}

static __inline unsigned int PopFromStack_1_32(tpEmulator pEm){
	KdPrint(("PopFromStack_1_32δģ\n"));
}

#endif // !defined(_DEFINE_CYZ_2011_2_5)