#ifndef EMR0_CYZ_2011_1_21
#define EMR0_CYZ_2011_1_21

#include "Base/Thread.h"

#define EM_ASYN_EVENT_NONE				0x0000
#define EM_ASYN_EVENT_DMA				0x0001
#define EM_ASYN_EVENT_DEBUG_BREAK		0x0002
#define EM_ASYN_EVENT_SUSPEND			0x0003
#define EM_ASYN_EVENT_HALT_NORMAL		0x0004
#define EM_ASYN_EVENT_HALT_UNNORMAL		0x0005

//ָкʱλ룩
#define EM_TIME_FOR_ONE_INSTR			6

typedef struct tEM{
	PVOID pCVC;
	int CpuCount;
	//cpuĵǰжֵ
	int EInum[MAX_LOGIC_CPU_COUNT];

	int EmuAsynEvent[MAX_LOGIC_CPU_COUNT];
	tThread ET[MAX_LOGIC_CPU_COUNT];

	//ǰʱ䣬λΪ루1 == 10^9)
	unsigned __int64 CurrentTime[MAX_LOGIC_CPU_COUNT];

#ifdef SS_DEBUG
	volatile bool IsWaiting4DbgCmd[MAX_LOGIC_CPU_COUNT];
	unsigned __int64 ic[MAX_LOGIC_CPU_COUNT];	//Instruction count
	unsigned __int64 cur_ic[MAX_LOGIC_CPU_COUNT];	//ǰеָ
	KEVENT	ehGetOneDbgCmd[MAX_LOGIC_CPU_COUNT];	//õ¼
	bool bc;		//ǷжϹ
	unsigned short CSBefInt;
	unsigned short IPBefInt;
#endif
}tEM,*tpEM;

EXERESULT EMR0Create(tpEM pEM);
EXERESULT EMR0Release(tpEM pEM);
EXERESULT EmR0SuspendThread(tpEM pEM,int ThreadID);
EXERESULT EmR0OffSuspendThread(tpThread pThread);
EXERESULT EMR0Start(tpCVC pCVC);

void EmDMA_Run(tpCVC pCVC);

__inline void AdvanceTime(unsigned __int64 * pCurTime, unsigned int interval){
	*pCurTime += interval;
}

#endif // !defined(EMR0_CYZ_2011_1_21)