#ifndef FLOPPYR0_CYZ_2011_1_27
#define FLOPPYR0_CYZ_2011_1_27

#include "BI.h"

#define FLOPPY_CMD_MAX_LENGTH		10	//󳤶Ϊ9( <10 )
#define	FLOPPY_CMD_RET_MAX_LENGTH	8	//󳤶Ϊ7( <8  )
#define FLOPPY_MAX_DRIVER_COUNT		4	//󳤶Ϊ2( <4  )

#define FLOPPY_SECTOR_SIZE			512

#define FLOPPY_MAIN_STATUS_MRQ		0x80			//main request
#define FLOPPY_MAIN_STATUS_DIO		0x40			//data input/output
#define FLOPPY_MAIN_STATUS_NDMA		0x20			//non-DMA mode
#define FLOPPY_MAIN_STATUS_BUSY		0x10			//instruction (device busy)
#define FLOPPY_MAIN_STATUS_ACTD		0x08			//drive D, C, B, A in positioning mode
#define FLOPPY_MAIN_STATUS_ACTC		0x04
#define FLOPPY_MAIN_STATUS_ACTB		0x02
#define FLOPPY_MAIN_STATUS_ACTA		0x01

#define FLOPPY_CUR_TYPE_360KB		0x00
#define FLOPPY_CUR_TYPE_1440KB		0x01

typedef struct tFloppyType{
	int type;
	unsigned char HeadCount;		//ͷ
	unsigned char CylinderCount;	//ŵ
	unsigned char SectorsPerTrack;
}tFloppyType,*tpFloppyType;

typedef struct tFloppy{
	PVOID pCVC;
	WCHAR * FilePath;
	HANDLE FileHandle;

	tFloppyType ft;

	bool IsInterrputState;	//ǷжϹ
	KTIMER	Timer;
	KDPC  TimerDpc;
	unsigned char DOR;		//Digital Output Register	3F2
	unsigned char MSR;		//Main Status Register		3F4
	unsigned char DR;		//Data  Register			3F5

	unsigned char ST0;		//״̬0
	unsigned char ST1;
	unsigned char ST2;
	unsigned char ST3;

	struct{
		unsigned char cylinder[FLOPPY_MAX_DRIVER_COUNT];		//ǰ(ŵ)
		unsigned char head[FLOPPY_MAX_DRIVER_COUNT];			//ǰͷ
		unsigned char sector_num[FLOPPY_MAX_DRIVER_COUNT];		//ǰ
		unsigned char sector_size[FLOPPY_MAX_DRIVER_COUNT];		//ǰС
	}Index;

	//ibm5160techref.pdf	page. 166
	struct{
		bool IsFullCmdFetched;
		bool MultiTrack;	//If MT is high,a cylinder under both HD0 and HD1 will be read or written.
		unsigned char CurIntactCmd;								//ǰؽһָ
		unsigned char cmd[FLOPPY_CMD_MAX_LENGTH];
		unsigned char ret[FLOPPY_CMD_RET_MAX_LENGTH];
		unsigned char CmdIndex;
		unsigned char RetIndex;
		unsigned char MaxCmdSize;
		unsigned char MaxRetSize;

		// This tells the controller the position and number of sectors to perform this command on.

	}Cmd;

}tFloppy,*tpFloppy;

EXERESULT FloppyLink(tpFloppy pFloppy);
EXERESULT FloppyUnLink(tpFloppy pFloppy);
void FloppyInit(tpFloppy pFloppy,PVOID pCVC);
void FloppyNextSector(tpFloppy pFloppy,int DiffSectorCount);

EXERESULT FloppyRegister(PVOID pDevice);


#endif // !defined(FLOPPYR0_CYZ_2011_1_27)