#ifndef PIC_CYZ_2011_2_23
#define PIC_CYZ_2011_2_23

#include "VMM/Device_IO.h"

typedef struct tPic{
	bool HasCreated;
	bool IsSinglePic;			//TRUE: Single PIC	;	FALSE: Cascaded PICs
	struct{
		bool HasInitByCpu;
		bool ICW4;				//TRUE: Will be Sending ICW4 ;  FALSE: Don't need ICW4
		bool LTIM;				//TRUE: Level Triggered Interrupts Mode	; FALSE: Edge Triggered Interrupts Mode
		bool CAI;				//TRUE: Call Address Interval of 4  ;	FALSE: Call Address Interval of 8
		bool Mode;				//TRUE: 8086/8080 Mode		;	FALSE: MCS-80/85
		bool AutoEOI;			//TRUE: Auto EOI			;	FALSE: Normal EOI
		bool BufMode;			//TRUE:	Non-Buffered Mode	;	FALSE: Buffered Mode
		bool SFNM;				//TRUE: Special Fully Nested Mode
		bool IsISRInPort20;		//TRUE:	20˿ĴеΪISR ;	FALSE: ΪIRR
		unsigned char PreICW;
		unsigned char Irq_Start;
		unsigned char IrUsedForSlave;
		unsigned char IMR;		//жμĴ			21	˿ڶȡ
		unsigned char IRR;		//жĴIRR		20  ˿ڶȡ
		unsigned char ISR;		//ǰжϷĴ		20  ˿ڶȡ
	}Master;	//8259A

	struct{
		bool HasInitByCpu;
		bool ICW4;				//TRUE: Will be Sending ICW4			;	FALSE: Don't need ICW4
		bool LTIM;				//TRUE: Level Triggered Interrupts Mode	;	FALSE: Edge Triggered Interrupts Mode
		bool CAI;				//TRUE: Call Address Interval of 4		;	FALSE: Call Address Interval of 8
		bool Mode;				//TRUE: 8086/8080 Mode		;	FALSE: MCS-80/85
		bool AutoEOI;			//TRUE: Auto EOI			;	FALSE: Normal EOI
		bool BufMode;			//TRUE:	Non-Buffered Mode	;	FALSE: Buffered Mode
		bool SFNM;				//TRUE: Special Fully Nested Mode
		bool IsISRInPortA0;		//TRUE:	A0˿ĴеΪISR ;	FALSE: ΪIRR
		unsigned char PreICW;
		unsigned char Irq_Start;
		unsigned char SlavedTo;
		unsigned char IMR;		//жμĴ			A1 ˿ڶȡ
		unsigned char IRR;		//жĴIRR		A0 ˿ڶȡ
		unsigned char ISR;		//ǰжϷĴ		A0 ˿ڶȡ
	}Slave;		//8259A
}tPic,*tpPic;

EXERESULT PicCreate(tpPic pPic);
EXERESULT PicRelease(tpPic pPic);
EXERESULT PicInit(tpPic pPic);
void PicSentInterr2Cpu(tpPic pPic);

EXERESULT PicRegister(PVOID pDevice);

#endif // !defined(PIC_CYZ_2011_2_23)