#ifndef KEYBOARD_CYZ_2011_2_20
#define KEYBOARD_CYZ_2011_2_20

#include "VMM/Device_IO.h"


#define KB_BUF_MAX_SIZE				16

#define KB_PC_XT_DATA_SEG			0x400
#define KB_PC_XT_STATUS1_OFFSET		0x18
#define KB_PC_XT_STATUS2_OFFSET		0x19
#define KB_PC_XT_BUF_HEAD_P			0x1A
#define KB_PC_XT_BUF_TAIL_P			0x1C

#define KB_PC_XT_BUF_HEAD			0x1E

typedef struct tKeyboard{
	bool HasCreated;
	bool HasResetted;
	PVOID pCVC;

	KTIMER	Timer;
	KDPC  TimerDpc;

	unsigned char * pStatus1;
	unsigned char * pStatus2;
	unsigned char *pBufHead;
	unsigned char *pBufTail;

}tKeyboard,*tpKeyboard;

EXERESULT KeyboardCreate(tpKeyboard pKeyboard);
EXERESULT KeyboardInit(tpKeyboard pKeyboard,PVOID pCVC);
EXERESULT KeyboardRelease(tpKeyboard pKeyboard);

void KeyboardActTimer(tpKeyboard pKeyboard);

#endif // !defined(KEYBOARD_CYZ_2011_2_20)