#ifndef DMA_CYZ_2011_3_16
#define DMA_CYZ_2011_3_16

#define DMA_MAX_COUNT			2
#define DMA_MAX_CHANNEL_COUNT	4

#define DMA_CHANNEL_FOR_FLOPPY	2
#define DMA_CHANNEL_FOR_DISK	3

typedef struct tDMA{
	bool HasCreated;

	bool HLDA;    // Hold Acknowlege
	struct{
		bool Flip_Flop;				//ֽڡֽл
		bool ChanMask[DMA_MAX_CHANNEL_COUNT];
		unsigned short TAR;			//Temporary Address Register
		unsigned short TWCR;		//Temporary Word Count Register
		unsigned char SR;			//Status Register
		unsigned char CR;			//Command Register
		unsigned char TR;			//Temporary Register
		unsigned char MAR;			//Mask Register
		unsigned char RR;			//Request Register
		struct{
			bool IsUsed;
			unsigned short BAR;		//Base Address Registers
			unsigned short CAR;		//Current Address Registers
			unsigned short BWCR;	//Base Word Count Registers
			unsigned short CWCR;	//Current Word Count Registers
			unsigned short PR;		//Page Registers
			unsigned char  MOR;		//Mode Registers

			void (* DMAWrite)(PVOID pCVC ,int PhyMem,int ByteLen);		//RAM I/O
			void (* DMARead)(PVOID pCVC ,int PhyMem,int ByteLen);		//I/ORAM

		}Channel[DMA_MAX_CHANNEL_COUNT];

	}data[DMA_MAX_COUNT];

}tDMA,*tpDMA;

EXERESULT DMACreate(tpDMA pDMA,PVOID pCVC);
EXERESULT DMARelease(tpDMA pDMA,PVOID pCVC);
EXERESULT DMAInit(tpDMA pDMA);
EXERESULT DMARegister(PVOID pDevice);

void DMAGetDRQFromIO(PVOID pCVC,int Channel,bool value);
void DMASendHRQ2Cpu(PVOID pCVC);
void DMAGetHLDAFromCpu(PVOID pCVC ,int CurDMA,int CurChannel);
void DMARunChannel(PVOID pCVC ,int CurDMA,int CurChannel);

void DMAHandlerRegister(PVOID pCVC,
	void (* DMAWrite)(PVOID pCVC ,int PhyMem,int ByteLen),
	void (* DMARead)(PVOID pCVC ,int PhyMem,int ByteLen),
	unsigned int Channel
	);


#endif // !defined(DMA_CYZ_2011_3_16)