#ifndef DEVICE_CYZ_2011_2_18
#define DEVICE_CYZ_2011_2_18

#include "VMM/Device/BIOSR0.h"
#include "VMM/Device/SDMR0.h"
#include "VMM/Device/Keyboard.h"
#include "VMM/Device/Pic.h"
#include "VMM/Device/Chip.h"
#include "VMM/Device/Display.h"
#include "VMM/Device/Printer.h"
#include "VMM/Device/DMA.h"
#include "VMM/Device/Timer.h"
#include "VMM/Device_IO.h"


//˿
#define	PORT_COUNT					0x10000
#define USED_PORT_HANDLER_COUNT		60

//˿̱Ӧ(  < USED_PORT_HANDLER_COUNT   )
#define PORT_HANDLER_DEFAULT			0
#define	PORT_HANDLER_UNIMPORTANT		1
#define PORT_HANDLER_80_CHECKPOINT		2
#define PORT_HANDLER_60_KB				3
#define PORT_HANDLER_64_KB				4
#define PORT_HANDLER_20_PIC				5
#define PORT_HANDLER_21_PIC				6
#define PORT_HANDLER_A0_PIC				7
#define PORT_HANDLER_A1_PIC				8
#define PORT_HANDLER_60_C8255			9
#define PORT_HANDLER_61_C8255			10
#define PORT_HANDLER_62_C8255			11
#define PORT_HANDLER_63_C8255			12

#if CPU_TYPE == 0

#define PORT_HANDLER_3B4_MDA			13
#define PORT_HANDLER_3B5_MDA			14
#define PORT_HANDLER_3B8_MDA			15
#define PORT_HANDLER_3BA_MDA			16

#define PORT_HANDLER_3D4_CGA			17
#define PORT_HANDLER_3D5_CGA			18
#define PORT_HANDLER_3D8_CGA			19
#define PORT_HANDLER_3D9_CGA			20
#define PORT_HANDLER_3DA_CGA			21

#define PORT_HANDLER_278_LPRT			22
#define PORT_HANDLER_378_LPRT			23
#define PORT_HANDLER_3BC_LPRT			24

#define PORT_HANDLER_201_GAMECA			25

#define PORT_HANDLER_3F2_FLOPPY			26
#define PORT_HANDLER_3F4_FLOPPY			27
#define PORT_HANDLER_3F5_FLOPPY			28

#define PORT_HANDLER_00_DMA				29
#define PORT_HANDLER_01_DMA				30
#define PORT_HANDLER_02_DMA				31
#define PORT_HANDLER_03_DMA				32
#define PORT_HANDLER_04_DMA				33
#define PORT_HANDLER_05_DMA				34
#define PORT_HANDLER_06_DMA				35
#define PORT_HANDLER_07_DMA				36
#define PORT_HANDLER_08_DMA				37
#define PORT_HANDLER_09_DMA				38
#define PORT_HANDLER_0A_DMA				39
#define PORT_HANDLER_0B_DMA				40
#define PORT_HANDLER_0C_DMA				41
#define PORT_HANDLER_0D_DMA				42
#define PORT_HANDLER_0E_DMA				43
#define PORT_HANDLER_0F_DMA				44
#define PORT_HANDLER_81_DMA				45
#define PORT_HANDLER_82_DMA				46
#define PORT_HANDLER_83_DMA				47


#define PORT_HANDLER_241_TIMER			48
#define PORT_HANDLER_341_TIMER			49
#define PROT_HANDLER_40_TIMER			50
#define PROT_HANDLER_41_TIMER			51
#define PROT_HANDLER_42_TIMER			52
#define PROT_HANDLER_43_TIMER			53

#endif	//CPU_TYPE == 0

typedef struct tDevice{
	bool HasCreated;
	PVOID	pCVC;
	tDMA	DMA;
	tSDM	Sdm;
	tBios	Bios;
	tKeyboard Keyboard;
	tDisplay Display;
	tPrinter Printer;
	//ɱжϿ
	tPic	Pic;
	//һЩоƬ
	tChip	Chips;

	//Programmable Interrupt Timer
	tTimer  Timer;

	unsigned char Port2HandlerId[PORT_COUNT];
	tIO_Handler IO_Handler[USED_PORT_HANDLER_COUNT];

}tDevice,*tpDevice;

EXERESULT DeviceCreate(tpDevice pDevice,PVOID pCVC);
EXERESULT DeviceReleaseAllCreated(tpDevice pDevice);
EXERESULT DeviceRelease(tpDevice pDevice);
EXERESULT DeviceInit(tpDevice pDevice,PVOID pCVC);
EXERESULT DeviceRegisterIOHandler(tpDevice pDevice);

EXERESULT ChkPointRegister_80(tpIO_Handler pIO_Handler);
EXERESULT NMI_Mask_Register_A0(tpIO_Handler pIO_Handler);

#endif // !defined(DEVICE_CYZ_2011_2_18)