#ifndef CPUMR0_CYZ_2011_1_21
#define CPUMR0_CYZ_2011_1_21

union{
		unsigned int _Zero32;
		unsigned short _Zero16;
		char _Zero8;
}_Zero;

typedef struct tSegment{
	unsigned short v;
	struct{
		unsigned int Base;
		unsigned short Access;
		unsigned short Limits;
	}h;
}tSegment,*tpSegment;
typedef struct tReg{
	union{
		//unsigned __int64 _RAX;
		unsigned int	_EAX;
		unsigned short	_AX;
		struct{
			unsigned char _AL;
			unsigned char _AH;
		};
	};

	union{
		//unsigned __int64 _RCX;
		unsigned int	_ECX;
		unsigned short	_CX;
		struct{
			unsigned char _CL;
			unsigned char _CH;
		};
	};

	union{
		//unsigned __int64 _RDX;
		unsigned int	_EDX;
		unsigned short	_DX;
		struct{
			unsigned char _DL;
			unsigned char _DH;
		};
	};

	union{
		//unsigned __int64 _RBX;
		unsigned int	_EBX;
		unsigned short	_BX;
		struct{
			unsigned char _BL;
			unsigned char _BH;
		};
	};

	union{
		//unsigned __int64 _RSP;
		unsigned int _ESP;
		unsigned short _SP;
	};

	union{
		//unsigned __int64 _RBP;
		unsigned int _EBP;
		unsigned short _BP;
	};

	union{
		//unsigned __int64 _RSI;
		unsigned int _ESI;
		unsigned short _SI;
	};

	union{
		//unsigned __int64 _RDI;
		unsigned int _EDI;
		unsigned short _DI;
	};

	tSegment xCS;
	tSegment xDS;
	tSegment xSS;
	tSegment xES;
	tSegment xFS;
	tSegment xGS;
	union{
		//unsigned __int64 _RFLAGS;
		unsigned int _EFLAGS;
	};

	union{
		//unsigned __int64 _RIP;
		unsigned int _EIP;
		unsigned short _IP;
	};

	unsigned int CR0;
	unsigned int CR1;
	unsigned int CR2;
	unsigned int CR3;
	unsigned int CR4;

	unsigned int DR0;
	unsigned int DR1;
	unsigned int DR2;
	unsigned int DR3;
	unsigned int DR4;
	unsigned int DR5;
	unsigned int DR6;
	unsigned int DR7;
	unsigned int GDTR;
	unsigned int LDTR;
	struct{
		unsigned int Base;
		unsigned short Limit;
	}IDTR;
	unsigned int TR;
	unsigned int MTRRs;
	unsigned int MSRs;

}tReg,*tpReg;

typedef struct tCpu{
	bool HasCreated;
	tpReg pReg;
	int name;
	int kind;
	int count;
}tCpu,*tpCpu;

EXERESULT CPUMR0Create(tpCpu pCpu);
EXERESULT CPUMR0Release(tpCpu pCpu);
EXERESULT CPUMR0InitCpu(tpCpu pCpu);

#endif // !defined(CPUMR0_CYZ_2011_1_21)