
#include <ntddk.h>
#include "LDasm.h"

extern KAFFINITY KeSetAffinityThread ( PKTHREAD Thread, KAFFINITY Affinity );

#define kmalloc(_s)	ExAllocatePoolWithTag(NonPagedPool, _s, 'neek')
#define kfree(_p)	ExFreePool(_p)

#define CLEAR_WP()                      \
    __asm   cli                         \
    __asm   mov     eax,cr0             \
    __asm   and     eax,not 000010000h  \
	__asm   mov     cr0,eax

#define SET_WP()                        \
    __asm   mov     eax,cr0             \
    __asm   or      eax,000010000h      \
    __asm   mov     cr0,eax             \
	__asm   sti

typedef struct _HOOK_POINT
{
	ULONG HookType;
	ULONG FuncLen;
	ULONG HookAddr;

}HOOK_POINT, *PHOOK_POINT;

typedef enum _INLINE_ENGINE_TYPES
{
	Automatic,
	CallHookE8,
	CallHookFF15,
	InlineHookPre2,  // +ת
	InlineHookPre1,  // ͷ5ֽJMP
	InlineHookDep2,  // push+ret
	InlineHookDep1,  // JMP
	InlineCrazyPatch
		
} INLINE_ENGINE_TYPES;

#pragma pack(1)
typedef struct _JMP_CODE
{
	UCHAR Jmp;
	ULONG JmpOffset;

}JMP_CODE, *PJMP_CODE;

typedef struct _HOOK_INFO
{
	UCHAR Type;				/*1*/
	UCHAR CodeLen;			/*2*/
	ULONG OrgAddr;			/*6*/
	ULONG NewCallVal;		/*10*/
	ULONG OrgCallval;		/*14*/
	JMP_CODE JmpNewCode;	/*19*/
	UCHAR OrgCode[5];		/*24*/
	JMP_CODE JmpOrgCode;	/*29*/
	UCHAR unknown[7];		/*36*/

}HOOK_INFO, *PHOOK_INFO;

#pragma pack()

HOOK_POINT g_strucHookPoint;
ULONG NumberOfRaisedCPU;
ULONG AllCPURaised;
PKDPC g_basePKDPC;
KIRQL g_NewIRQL;

BOOLEAN GetHookPoint(	PUCHAR pCode, 
						ULONG nCodeLen, 
						ULONG nTotalLen, 
						ULONG nFuncLen, 
						ULONG HookType )
{
	UCHAR bRet = 0;
	if ( nTotalLen >= nFuncLen ){
		return 0;
	}
	if ( nTotalLen != 2 && nCodeLen != 2 ){
		if ( nCodeLen == 5 ){
			
			//
			//  for call opt
			//
			
			if ( *pCode == 0xe8 ){
				g_strucHookPoint.HookType = CallHookE8;
				g_strucHookPoint.FuncLen = nTotalLen;
				g_strucHookPoint.HookAddr = (ULONG)(pCode + 1);
				return TRUE;
			}

			//
			//  not call and is valid
			//
			
			if ( nTotalLen > 7 && nTotalLen < (2 * nFuncLen / 3) ){
				if ( HookType == InlineHookDep1 ){
					g_strucHookPoint.HookType = InlineHookDep1;
					g_strucHookPoint.FuncLen = nTotalLen;
					g_strucHookPoint.HookAddr = (ULONG)pCode;
					return TRUE;
				}
				if ( g_strucHookPoint.HookType == Automatic ){
					
					g_strucHookPoint.HookType = InlineHookDep1;
					g_strucHookPoint.FuncLen = nTotalLen;
					g_strucHookPoint.HookAddr = (ULONG)pCode;
					return FALSE;
				}
			}

			return FALSE;
		
		//
		//  for nlen == 6
		//
		
		}else if ( nCodeLen == 6 ){

			if ( nTotalLen > 7 && nTotalLen < (2 * nFuncLen / 3) ){
				if ( HookType == InlineHookDep2 )
				{
					g_strucHookPoint.HookType = InlineHookDep2;
					g_strucHookPoint.FuncLen = nTotalLen;
					g_strucHookPoint.HookAddr = (ULONG)pCode;
					return TRUE;
				}
				if ( g_strucHookPoint.HookType == Automatic )
				{
					g_strucHookPoint.HookType = InlineHookDep2;
					g_strucHookPoint.FuncLen = nTotalLen;
					g_strucHookPoint.HookAddr = (ULONG)pCode;
					//return FALSE;
				}
			}
			if ( *(USHORT*)pCode == 0x15FF )
			{
				g_strucHookPoint.HookType = CallHookFF15;
				g_strucHookPoint.FuncLen = nTotalLen;
				g_strucHookPoint.HookAddr = (ULONG)(pCode + 2);
				return TRUE;
			}

			return FALSE;
		}
	}
	
	if ( *(ULONG*)pCode == 0x8B55FF8B &&
		 pCode[4] == 0xEC ){
		if ( HookType == InlineHookPre1 ){
			
			g_strucHookPoint.HookType = InlineHookPre1;
			g_strucHookPoint.FuncLen = 2;
			g_strucHookPoint.HookAddr = (ULONG)pCode;
			return TRUE;
		}
	}
	if ( *(USHORT*)pCode == 0xFF8B  ){
		if ( (*((ULONG*)pCode - 1) == 0xCCCCCCCC && *(pCode - 5) == 0xCC) || 
			 (*((ULONG*)pCode - 1) ==0x90909090 && *(pCode - 5) == 0x90u) ){
			if ( HookType == InlineHookPre2 ){
				g_strucHookPoint.HookType = InlineHookPre2;
				g_strucHookPoint.FuncLen = 2;
				g_strucHookPoint.HookAddr = (ULONG)pCode;
				return TRUE;
			}
		}
	}
	
	return FALSE;
}

ULONG GetFuncHookPoint( ULONG uFuncAddr, int nHookType )
{
	ULONG uFuncAddrTmp = uFuncAddr;
	ULONG uFuncLen = 0, uCodeLen = 0;
	ULONG uTotalLen = 0;
	UCHAR uRet = 0;
	UCHAR *pOpcode;

	g_strucHookPoint.FuncLen = 0;
	g_strucHookPoint.HookAddr = 0;
	g_strucHookPoint.HookType = 0;
	
	if ( uFuncAddr ){
		uFuncLen = SizeOfProc( (PVOID)uFuncAddr );
		if ( uFuncLen > 0 ){
			do
			{
				uCodeLen = SizeOfCode( (PVOID)uFuncAddrTmp, &pOpcode );
				uTotalLen += uCodeLen;
				uFuncAddrTmp += uCodeLen;
				uRet = GetHookPoint( pOpcode, uCodeLen, uTotalLen, uFuncLen, nHookType );

			}while ( !uRet && uTotalLen < uFuncLen );
		}
	}
	return uRet;
}

ULONG FindPushRet( ULONG NewFunctionAddr )
{
	ULONG uRet = NewFunctionAddr;
	
	//
	//  Ӧüһ,ø󳤶
	//
	
	while ( *(UCHAR*)uRet != 0x68 || *(UCHAR*)(uRet + 5) != 0xC3 )
	{
		uRet++;
	}
	
	return ++uRet;
}

VOID RaiseCPUIrqlAndWait(
						 IN PKDPC Dpc,
						 IN PVOID DeferredContext,
						 IN PVOID SystemArgument1,
						 IN PVOID SystemArgument2
						 )
{
	InterlockedIncrement(&NumberOfRaisedCPU);
	while (!InterlockedCompareExchange( &AllCPURaised, 1, 1 )){
		__asm nop;
	}
	InterlockedDecrement(&NumberOfRaisedCPU);
}

BOOLEAN GainExlusivity(VOID)

{
	
	NTSTATUS ntStatus;
	ULONG u_currentCPU;
	CCHAR i;
	PKDPC pKdpc, temp_pkdpc;
	
	KIRQL NewIrql;

	/*if (DISPATCH_LEVEL != KeGetCurrentIrql())
	{
		return FALSE;
	}*/

	NewIrql = KeRaiseIrqlToDpcLevel();
	
	InterlockedAnd(&NumberOfRaisedCPU, 0);
	InterlockedAnd(&AllCPURaised, 0);
	
	temp_pkdpc = (PKDPC)kmalloc(KeNumberProcessors * sizeof(KDPC));
	
	if (NULL == temp_pkdpc){
		KfLowerIrql(NewIrql);
		return FALSE;
	}
	
	g_basePKDPC = temp_pkdpc;
	u_currentCPU = KeGetCurrentProcessorNumber();
	
	for (i = 0; i < KeNumberProcessors; i++, *temp_pkdpc++){
		if ( i != u_currentCPU ){
			KeInitializeDpc( temp_pkdpc, RaiseCPUIrqlAndWait, NULL );
			KeSetTargetProcessorDpc( temp_pkdpc, i );
			KeInsertQueueDpc( temp_pkdpc, NULL, NULL );
		}
	}
	while( (KeNumberProcessors - 1) != InterlockedCompareExchange( &NumberOfRaisedCPU, KeNumberProcessors - 1, KeNumberProcessors - 1) )
	{
		__asm nop;
	}

	g_NewIRQL = NewIrql;

	return TRUE;
	
}

void ReleaseExclusivity()
{
	InterlockedIncrement(&AllCPURaised);
	while (InterlockedCompareExchange(&NumberOfRaisedCPU, 0, 0))
	{
		__asm nop;
	}
	if (NULL != g_basePKDPC){
		kfree((PVOID)g_basePKDPC);
		g_basePKDPC = NULL;
	}
	
	KfLowerIrql(g_NewIRQL);	
}

VOID __stdcall SetWp()
{
    SET_WP();
    ReleaseExclusivity();
}

BOOLEAN __stdcall ClearWp()
{
	BOOLEAN bRet = GainExlusivity();
    CLEAR_WP();
	return bRet;
}

BOOLEAN fnInlineHookPre1( ULONG NewFunctionAddr )
{
	ULONG uPushRet = 0;
	PHOOK_INFO pInfo;

	//
	//  Check paramter and Hook struct
	//
	
	if ( g_strucHookPoint.HookType != InlineHookPre1 || \
		 !g_strucHookPoint.HookAddr || \
		 *(ULONG*)g_strucHookPoint.HookAddr != 0x8B55FF8B || \
		 *(UCHAR*)(g_strucHookPoint.HookAddr + 4) != 0xEC ){
		return FALSE;
	}
	
	//
	//  Find the Push and ret
	//  Note: The new function must be end of with (push XXXX;ret)
	//
	
	uPushRet = FindPushRet( NewFunctionAddr );
	if ( *(ULONG*)uPushRet ){
		return FALSE;
	}
	
	//
	//  Allocate memory for HOOK_INFO
	//
	
	pInfo = (PHOOK_INFO)kmalloc( sizeof(HOOK_INFO) );
	if ( !pInfo ){
		return FALSE;
	}
	RtlZeroMemory( pInfo, sizeof(HOOK_INFO) );
	
	pInfo->JmpNewCode.JmpOffset = 0;
	pInfo->Type = InlineHookPre1;
	pInfo->CodeLen = 5;
	pInfo->OrgAddr = g_strucHookPoint.HookAddr;
	pInfo->JmpNewCode.Jmp = 0xE9;
	pInfo->JmpNewCode.JmpOffset = NewFunctionAddr - \
		   ((ULONG)pInfo + 5 /*sizeof 'JMP XXXX' opt*/ + FIELD_OFFSET(HOOK_INFO, JmpNewCode));
	RtlCopyMemory( pInfo->OrgCode, g_strucHookPoint.HookAddr, 5 );
	pInfo->JmpOrgCode.Jmp = 0xE9;
	pInfo->JmpOrgCode.JmpOffset = g_strucHookPoint.HookAddr + 5/*size of shell code*/ - \
		   ((ULONG)pInfo + 5 /*sizeof 'JMP XXXX' opt*/ + FIELD_OFFSET(HOOK_INFO, JmpOrgCode));

	if ( KeNumberProcessors > 1 )
	{
		PVOID pThread;
		pThread = KeGetCurrentThread();
		KeSetAffinityThread( pThread, KeNumberProcessors );
	}
	
	//
	//  do hook
	//
	
	if ( ClearWp() ){
		((PJMP_CODE)g_strucHookPoint.HookAddr)->Jmp = 0xE9;
		((PJMP_CODE)g_strucHookPoint.HookAddr)->JmpOffset = \
			(ULONG)pInfo + FIELD_OFFSET(HOOK_INFO, JmpNewCode) - (g_strucHookPoint.HookAddr + 5);
		*(ULONG*)uPushRet = (ULONG)pInfo + FIELD_OFFSET(HOOK_INFO, OrgCode);
		SetWp();
		return TRUE;
	}

	return FALSE;
}

BOOLEAN fnCallHookE8( ULONG NewFunctionAddr )
{
	ULONG uPushRet = 0;
	PHOOK_INFO pInfo;
	
	//
	//  Check paramter and Hook struct
	//
	
	if ( g_strucHookPoint.HookType != CallHookE8 || \
		!g_strucHookPoint.HookAddr){
		return FALSE;
	}
	
	//
	//  Find the Push and ret
	//  Note: The new function must be end of with (push XXXX;ret)
	//
	
	uPushRet = FindPushRet( NewFunctionAddr );
	if ( *(ULONG*)uPushRet ){
		return FALSE;
	}
	
	//
	//  Allocate memory for HOOK_INFO
	//
	
	pInfo = (PHOOK_INFO)kmalloc( sizeof(HOOK_INFO) );
	if ( !pInfo ){
		return FALSE;
	}
	RtlZeroMemory( pInfo, sizeof(HOOK_INFO) );
	
	//
	//  fill the struct
	//
	
	pInfo->JmpNewCode.JmpOffset = 0;

	pInfo->Type = CallHookE8;
	pInfo->CodeLen = 4;
	pInfo->OrgAddr = g_strucHookPoint.HookAddr;
	pInfo->NewCallVal = (ULONG)pInfo - g_strucHookPoint.HookAddr + 10;
	pInfo->OrgCallval = *(ULONG*)g_strucHookPoint.HookAddr;
	pInfo->JmpNewCode.Jmp = 0xE9;
	pInfo->JmpNewCode.JmpOffset = NewFunctionAddr - \
					(ULONG)pInfo - 5 - FIELD_OFFSET(HOOK_INFO, JmpNewCode);
	((PJMP_CODE)(pInfo->OrgCode))->Jmp = 0xE9;
	
	//
	//  NOTE ( For example )
	//
	//  ORG_CALL: CALL CALLADDR1
	//  CALLADDR1 = Target - ORG_CALL - sizeof(opt)/*5*/;
	//  ==> Target = CALLADDR1 + ORG_CALL + sizeof(opt);
	//  SHELL_JMP: JMP CALLADDR2  --> JMP to target
	//	CALLADDR2 = Target - SHELL_JMP - sizeof(opt)/*5*/;
	//  ==> CALLADDR2 = CALLADDR1 + ORG_CALL + sizeof(opt) - SHELL_JMP - sizeof(opt)
	//  ==> CALLADDR2 = CALLADDR1 + ORG_CALL - SHELL_JMP;
	//  CALLADDR2 ==(is)== ((PJMP_CODE)(pInfo->OrgCode))->JmpOffset
	//  CALLADDR1  ==(is)== *(ULONG*)g_strucHookPoint.HookAddr
	//  ORG_CALL ==(is)== g_strucHookPoint.HookAddr - 1 (Ϊȡַʱûм0xE8)
	//  SHELL_JMP ==(is)== (ULONG)pInfo + FIELD_OFFSET(HOOK_INFO, OrgCode)
	//

	((PJMP_CODE)(pInfo->OrgCode))->JmpOffset = (*(ULONG*)g_strucHookPoint.HookAddr) + \
											   (g_strucHookPoint.HookAddr - 1) - \
											   ((ULONG)pInfo + FIELD_OFFSET(HOOK_INFO, OrgCode) /*19*/);

	if ( KeNumberProcessors > 1 )
	{
		PVOID pThread;
		pThread = KeGetCurrentThread();
		KeSetAffinityThread( pThread, KeNumberProcessors );
	}
	
	//
	//  do hook
	//
	
	if ( ClearWp() ){
		*(ULONG*)g_strucHookPoint.HookAddr = pInfo->NewCallVal;
		*(ULONG*)uPushRet = (ULONG)pInfo + FIELD_OFFSET(HOOK_INFO, OrgCode);
		SetWp();
		return TRUE;
	}
	return FALSE;

}

BOOLEAN fnCallHookFF15( ULONG NewFunctionAddr )
{
	ULONG uPushRet = 0;
	PHOOK_INFO pInfo;
	
	//
	//  Check paramter and Hook struct
	//
	
	if ( g_strucHookPoint.HookType != CallHookFF15 || \
		!g_strucHookPoint.HookAddr){
		return FALSE;
	}
	
	//
	//  Find the Push and ret
	//  Note: The new function must be end of with (push XXXX;ret)
	//
	
	uPushRet = FindPushRet( NewFunctionAddr );
	if ( *(ULONG*)uPushRet ){
		return FALSE;
	}
	
	//
	//  Allocate memory for HOOK_INFO
	//
	
	pInfo = (PHOOK_INFO)kmalloc( sizeof(HOOK_INFO) );
	if ( !pInfo ){
		return FALSE;
	}
	RtlZeroMemory( pInfo, sizeof(HOOK_INFO) );

	pInfo->JmpNewCode.JmpOffset = 0;
	pInfo->Type = CallHookFF15;
	pInfo->CodeLen = 4;
	pInfo->OrgAddr = g_strucHookPoint.HookAddr;
	pInfo->NewCallVal = (ULONG)pInfo + FIELD_OFFSET(HOOK_INFO, JmpNewCode);
	pInfo->OrgCallval = *(ULONG*)g_strucHookPoint.HookAddr;
	pInfo->JmpNewCode.Jmp = 0xE9;
	pInfo->JmpNewCode.JmpOffset = NewFunctionAddr - 
						(ULONG)pInfo - FIELD_OFFSET(HOOK_INFO, JmpNewCode) - 5;
	((PJMP_CODE)(pInfo->OrgCode))->Jmp = 0xE9;
	((PJMP_CODE)(pInfo->OrgCode))->JmpOffset = (**((ULONG**)(g_strucHookPoint.HookAddr))) - \
									(ULONG)pInfo - FIELD_OFFSET(HOOK_INFO, OrgCode) - 5;
	
	if ( KeNumberProcessors > 1 )
	{
		PVOID pThread;
		pThread = KeGetCurrentThread();
		KeSetAffinityThread( pThread, KeNumberProcessors );
	}
	
	//
	//  do hook
	//
	
	if ( ClearWp() ){
		*(ULONG*)g_strucHookPoint.HookAddr = (ULONG)pInfo + FIELD_OFFSET(HOOK_INFO, JmpNewCode);
		*(ULONG*)uPushRet = (ULONG)pInfo + FIELD_OFFSET(HOOK_INFO, OrgCode);
		SetWp();
		return TRUE;
	}
	return FALSE;
}

BOOLEAN fnInlineHookPre2( ULONG NewFunctionAddr )
{
	ULONG uPushRet = 0;
	PHOOK_INFO pInfo;
	
	//
	//  Check paramter and Hook struct
	//
	
	if ( g_strucHookPoint.HookType != InlineHookPre2 || \
		!g_strucHookPoint.HookAddr){
		return FALSE;
	}
	
	if ( *(USHORT*)g_strucHookPoint.HookAddr != 0xFF8 ){
		return FALSE;
	}
	
	if ( (*(ULONG*)(g_strucHookPoint.HookAddr - 4) != 0xCCCCCCCC || \
		 *(ULONG*)(g_strucHookPoint.HookAddr - 5) != 0xCC) && \
		 (*(ULONG*)(g_strucHookPoint.HookAddr - 4) != 0x90909090 || \
		 *(UCHAR*)(g_strucHookPoint.HookAddr - 5) != 0x90)){
		return FALSE;
	}
	//
	//  Find the Push and ret
	//  Note: The new function must be end of with (push XXXX;ret)
	//
	
	uPushRet = FindPushRet( NewFunctionAddr );
	if ( *(ULONG*)uPushRet ){
		return FALSE;
	}
	
	//
	//  Allocate memory for HOOK_INFO
	//
	
	pInfo = (PHOOK_INFO)kmalloc( sizeof(HOOK_INFO) );
	if ( !pInfo ){
		return FALSE;
	}
	RtlZeroMemory( pInfo, sizeof(HOOK_INFO) );

	pInfo->JmpNewCode.JmpOffset = 0;

	pInfo->Type = InlineHookPre2;
	pInfo->CodeLen = 2;
	pInfo->OrgAddr = g_strucHookPoint.HookAddr;
	pInfo->JmpNewCode.Jmp = 0xE9;
	pInfo->JmpNewCode.JmpOffset = NewFunctionAddr - 
						(ULONG)pInfo - FIELD_OFFSET(HOOK_INFO, JmpNewCode) - 5;
	*(USHORT*)(pInfo->OrgCode) = *(USHORT *)g_strucHookPoint.HookAddr;
	*(UCHAR*)((ULONG)(pInfo->OrgCode) + 2) = 0xE9;
	*(UCHAR*)((ULONG)(pInfo->OrgCode) + 3) = g_strucHookPoint.HookAddr - (ULONG)pInfo - \
						FIELD_OFFSET(HOOK_INFO, OrgCode) - 5;

	if ( KeNumberProcessors > 1 )
	{
		PVOID pThread;
		pThread = KeGetCurrentThread();
		KeSetAffinityThread( pThread, KeNumberProcessors );
	}
	
	//
	//  do hook
	//
	
	if ( ClearWp() ){
		*(UCHAR*)g_strucHookPoint.HookAddr = 0xEB;
		*(UCHAR*)(g_strucHookPoint.HookAddr + 1) = 0xF9;
		*(UCHAR*)(g_strucHookPoint.HookAddr - 5) = 0xE9;
		*(ULONG*)(g_strucHookPoint.HookAddr - 4) = (ULONG)pInfo + \
				FIELD_OFFSET(HOOK_INFO, OrgCode) - g_strucHookPoint.HookAddr - 5;
		*(ULONG*)uPushRet = (ULONG)pInfo + FIELD_OFFSET(HOOK_INFO, OrgCode);
		SetWp();
		return TRUE;
	}
	return FALSE;
}

BOOLEAN fnInlineHookDep2( ULONG NewFunctionAddr )
{
	ULONG uPushRet = 0;
	PHOOK_INFO pInfo;
	
	//
	//  Check paramter and Hook struct
	//
	
	if ( g_strucHookPoint.HookType != InlineHookDep2 || \
		!g_strucHookPoint.HookAddr){
		return FALSE;
	}
	
	//
	//  Find the Push and ret
	//  Note: The new function must be end of with (push XXXX;ret)
	//
	
	uPushRet = FindPushRet( NewFunctionAddr );
	if ( *(ULONG*)uPushRet ){
		return FALSE;
	}
	
	//
	//  Allocate memory for HOOK_INFO
	//
	
	pInfo = (PHOOK_INFO)kmalloc( sizeof(HOOK_INFO) );
	if ( !pInfo ){
		return FALSE;
	}
	RtlZeroMemory( pInfo, sizeof(HOOK_INFO) );
	
	pInfo->JmpNewCode.JmpOffset = 0;
	
	pInfo->Type = InlineHookDep2;
	pInfo->CodeLen = 6;
	pInfo->OrgAddr = g_strucHookPoint.HookAddr;
	pInfo->JmpNewCode.Jmp = 0xE9;
	pInfo->JmpNewCode.JmpOffset = NewFunctionAddr - 
						(ULONG)pInfo - FIELD_OFFSET(HOOK_INFO, JmpNewCode) - 5;
	//RtlCopyMemory( pInfo->OrgCode, g_strucHookPoint.HookAddr, 6 );
	*(ULONG *)((ULONG)pInfo + 19) = *(ULONG*)(g_strucHookPoint.HookAddr);
	*(USHORT*)((ULONG)pInfo + 23) = *(USHORT*)(g_strucHookPoint.HookAddr + 4);
	*(UCHAR*)((ULONG)pInfo + 25) = 0xE9;
	*(ULONG *)((ULONG)pInfo + 26) = g_strucHookPoint.HookAddr - (ULONG)pInfo - \
				FIELD_OFFSET(HOOK_INFO, OrgCode) - 5;
	if ( KeNumberProcessors > 1 )
	{
		PVOID pThread;
		pThread = KeGetCurrentThread();
		KeSetAffinityThread( pThread, KeNumberProcessors );
	}
	
	//
	//  do hook
	//
	
	if ( ClearWp() ){
		*(UCHAR*)g_strucHookPoint.HookAddr = 0x68;
		*(ULONG*)(g_strucHookPoint.HookAddr + 1) = (ULONG)pInfo + FIELD_OFFSET(HOOK_INFO, JmpNewCode);
		*(UCHAR*)(g_strucHookPoint.HookAddr + 5) = 0xC3;
		*(ULONG*)uPushRet = (ULONG)pInfo + FIELD_OFFSET(HOOK_INFO, OrgCode);
		SetWp();
		return TRUE;
	}
	return FALSE;
}

BOOLEAN fnInlineHookDep1( ULONG NewFunctionAddr )
{
	ULONG uPushRet = 0;
	PHOOK_INFO pInfo;
	
	//
	//  Check paramter and Hook struct
	//
	
	if ( g_strucHookPoint.HookType != InlineHookDep1 || \
		!g_strucHookPoint.HookAddr){
		return FALSE;
	}
	
	//
	//  Find the Push and ret
	//  Note: The new function must be end of with (push XXXX;ret)
	//
	
	uPushRet = FindPushRet( NewFunctionAddr );
	if ( *(ULONG*)uPushRet ){
		return FALSE;
	}
	
	//
	//  Allocate memory for HOOK_INFO
	//
	
	pInfo = (PHOOK_INFO)kmalloc( sizeof(HOOK_INFO) );
	if ( !pInfo ){
		return FALSE;
	}
	RtlZeroMemory( pInfo, sizeof(HOOK_INFO) );
	
	pInfo->JmpNewCode.JmpOffset = 0;
	
	pInfo->Type = InlineHookDep1;
	pInfo->CodeLen = 5;
	pInfo->OrgAddr = g_strucHookPoint.HookAddr;
	pInfo->JmpNewCode.Jmp = 0xE9;
	pInfo->JmpNewCode.JmpOffset = NewFunctionAddr - 
						(ULONG)pInfo - FIELD_OFFSET(HOOK_INFO, JmpNewCode) - 5;
	*(ULONG*)((ULONG)pInfo + 19) = *(ULONG *)g_strucHookPoint.HookAddr;
	*(UCHAR*)((ULONG)pInfo + 23) = *(UCHAR*)(g_strucHookPoint.HookAddr + 4);
	pInfo->JmpOrgCode.Jmp = 0xE9;
	pInfo->JmpOrgCode.JmpOffset = g_strucHookPoint.HookAddr - (ULONG)pInfo - \
						FIELD_OFFSET(HOOK_INFO, OrgCode) - 5;

	if ( KeNumberProcessors > 1 )
	{
		PVOID pThread;
		pThread = KeGetCurrentThread();
		KeSetAffinityThread( pThread, KeNumberProcessors );
	}
	
	//
	//  do hook
	//
	
	if ( ClearWp() ){
		((PJMP_CODE)(g_strucHookPoint.HookAddr))->Jmp = 0xE9;
		((PJMP_CODE)(g_strucHookPoint.HookAddr))->JmpOffset = (ULONG)pInfo + FIELD_OFFSET(HOOK_INFO, JmpNewCode) - 5;
		*(ULONG*)uPushRet = (ULONG)pInfo + FIELD_OFFSET(HOOK_INFO, JmpOrgCode);
		SetWp();
		return TRUE;
	}
	return FALSE;
}

BOOLEAN
HookCode95 ( PVOID  pTarFunction, PVOID  pNewFunction, ULONG  HookNumber )
{
	BOOLEAN bRet = FALSE;
	if ( !pTarFunction || !pNewFunction ){
		return FALSE;
	}
	GetFuncHookPoint( pTarFunction, HookNumber );
	if ( !g_strucHookPoint.HookType ){
		return FALSE;
	}
	switch( g_strucHookPoint.HookType )
	{
	case CallHookE8:
		bRet = fnCallHookE8( (ULONG)pNewFunction );
		break;
	case CallHookFF15:
		bRet = fnCallHookFF15( (ULONG)pNewFunction );
		break;
	case InlineHookPre2:
		bRet = fnInlineHookPre2( (ULONG)pNewFunction );
		break;
	case InlineHookPre1:
		bRet = fnInlineHookPre1( (ULONG)pNewFunction );
		break;
	case InlineHookDep2:
		bRet = fnInlineHookDep2( (ULONG)pNewFunction );
		break;
	case InlineHookDep1:
		bRet = fnInlineHookDep1( (ULONG)pNewFunction );
		break;
	case InlineCrazyPatch:
		break;
	default:
		bRet = TRUE;
		break;
	}

	return bRet;
}
VOID UnhookCode95 ( PVOID pNewFunction )
{
	ULONG uPushRet = 0;
	if ( !pNewFunction ){
		return;
	}
	if ( KeNumberProcessors > 1 )
    {
		PVOID pThread;
		pThread = KeGetCurrentThread();
		KeSetAffinityThread( pThread, KeNumberProcessors );
    }

	uPushRet = FindPushRet( pNewFunction );
	if ( *(ULONG*)uPushRet ){
		//PHOOK_INFO pInfo = CONTAINING_RECORD( *(ULONG*)uPushRet, PHOOK_INFO, JmpOrgCode );
		PHOOK_INFO pInfo = *(ULONG*)uPushRet - 19;
		if ( !pInfo ){
			return;
		}
		if ( pInfo->Type != Automatic ){
			if ( pInfo->Type == CallHookE8 || pInfo->Type == CallHookFF15 ){
				if ( ClearWp() ){
					*(ULONG*)(pInfo->OrgAddr) = pInfo->OrgCallval;
					*(ULONG*)uPushRet = 0;
				}
			}else{
				if ( pInfo->Type == InlineHookPre2 )
				{
					if ( ClearWp() ){
						RtlCopyMemory( (PVOID)(pInfo->OrgAddr), (PVOID)(*(ULONG*)uPushRet), pInfo->CodeLen );
						*(ULONG*)(pInfo->OrgAddr - 4) = 0xCCCCCCCCu;
						*(UCHAR*)(pInfo->OrgAddr - 5) = 0xCCu;
					}
				}else{
					if ( pInfo->Type == 4 || pInfo->Type == 5 || pInfo->Type == 6 ){
						if ( ClearWp() )
							RtlCopyMemory( (PVOID)(pInfo->OrgAddr), (PVOID)(*(ULONG*)uPushRet), pInfo->CodeLen);
					}
				}
				*(ULONG*)uPushRet = 0;
			}
			SetWp();
		}
		kfree( pInfo );
	}
}
