#include "comm_fun.h"

////////////////////////////////////////////////////////////////////////////////
void zwsdumphex(  void *pBuffer2, ULONG LEN)
{
  ULONG i=0,j=0,space=0;
  unsigned char *pBuffer=(unsigned char *)pBuffer2;
  
  DbgPrint("offset: ");
  
  for (; i<16; i++)
  {
		DbgPrint("%X  ", i);
		if ((i+1)%8==0)
		{
		  DbgPrint(" ");
		}
  }
  DbgPrint("\r\n        ");
  
    for (i=0; i<LEN; i++)
	{
		DbgPrint("%02x ", pBuffer[i]);
		if ((i+1)%8==0)
		{
		  DbgPrint(" ");
		}
		if ((i+1)%16==0)
		{
		  
		    for (j= i-0xf; j!=i; j++)
			{
			  if(pBuffer[j]==0xc || pBuffer[j]==0x0d)
				{
					DbgPrint(" ");
					continue;
				}
			  DbgPrint("%c", pBuffer[j]);
			}
		  DbgPrint("\r\n        ");
		}
	}
	if (LEN%16!=0)
	{
	
	  i =LEN%16;
	  space = 16-i;
	  space = space*2+space+1;
	  for (i=0; i<space; i++)
	  {
	    DbgPrint(" ");
	  }
	  i =LEN%16;
	  for (j= LEN-i; j<LEN; j++)
	  {
	  		if(pBuffer[j]==0xc || pBuffer[j]==0x0d)
				{
					DbgPrint(" ");
					continue;
				}
			DbgPrint("%c", pBuffer[j]);
	  }
	}
  DbgPrint("\r\n");
}
void	redirect_recv_netbuffer_vista_later(NET_BUFFER *pNet_buffer)
{
	PUCHAR 			 pbuffer;
	PUCHAR			 pip;
    ULONG            ulbytes_copied,uNetbuffertLen, utmp;
	Dlc_Header *pdlc_header; //̫ͷָ
	Ip_Header  *pip_header;  //IPͷָ
	
	pdlc_header	=	NULL;
	pip_header	=	NULL;
	pbuffer		=	NULL;

	uNetbuffertLen	=	NET_BUFFER_DATA_LENGTH(pNet_buffer);
	//should confirm the packet contain the ip data.
	if(uNetbuffertLen<(sizeof(Dlc_Header)+sizeof(Ip_Header)))
	{
		DbgPrint("net buffer too small ,has no ip data\r\n");
		return ;
	}
	
	pbuffer = (PUCHAR)kmalloc(uNetbuffertLen);
	if(pbuffer==NULL)
	{
		DbgPrint("ExAllocatePoolWithTag for netbuffer memory fail \r\n");
		return;
	}
	NdisZeroMemory(pbuffer,uNetbuffertLen);//
	
	utmp	=	uNetbuffertLen;
	CopyBytesFromNetBuffer(pNet_buffer, &utmp, pbuffer);
	if (utmp!=uNetbuffertLen)
	{
		DbgPrint(("[recv] funny thing happens total len=%d, copied len %s\r\n", uNetbuffertLen, utmp));
	}
	pdlc_header	=	(Dlc_Header*)pbuffer;
	//жethertype,IP账,,PPPOEĻҪر
	if(ntohs(pdlc_header->ethertype)!=0x0800) 
	{
	//	DbgPrint((" NOT IP packet\r\n"));
		if(pbuffer)
		{
			kfree(pbuffer);pbuffer=NULL;
			return ;
		}
	}
	
	pip_header=(Ip_Header  *)(pbuffer+14);
	pip	=	(PUCHAR)&pip_header->sourceIP;

	DbgPrint("[packet recv] IP : %d.%d.%d.%d.\r\n",pip[0],pip[1], pip[2],pip[3]);
	if(pbuffer)
	{
		kfree(pbuffer);pbuffer=NULL;
	}
	return ;

}

////////////////////////////////////////////////////////////////////////////////
void	redirect_send_netbuffer_vista_later(NET_BUFFER *pNet_buffer, ULONG FROM_IP, ULONG TO_IP)
{
	PUCHAR 			 pbuffer;
	PUCHAR			 pip;
    ULONG            ulbytes_copied,uNetbuffertLen, utmp;
	Dlc_Header *pdlc_header; //̫ͷָ
	Ip_Header  *pip_header;  //IPͷָ
	Tcp_Header *ptcp_header=NULL; //TCPͷָ
	pdlc_header	=	NULL;
	pip_header	=	NULL;
	pbuffer		=	NULL;
	
	uNetbuffertLen	=	NET_BUFFER_DATA_LENGTH(pNet_buffer);
	//should confirm the packet contain the ip data.
	if(uNetbuffertLen<(sizeof(Dlc_Header)+sizeof(Ip_Header)))
	{
		DbgPrint("net buffer too small ,has no ip data\r\n");
		return ;
	}
	
	pbuffer = (PUCHAR)kmalloc(uNetbuffertLen);
	if(pbuffer==NULL)
	{
		DbgPrint("ExAllocatePoolWithTag for netbuffer memory fail \r\n");
		return;
	}
	NdisZeroMemory(pbuffer,uNetbuffertLen);//
	
	utmp	=	uNetbuffertLen;
	CopyBytesFromNetBuffer(pNet_buffer, &utmp, pbuffer);
	if (utmp!=uNetbuffertLen)
	{
		DbgPrint(("[send] funny thing happens total len=%d, copied len %s\r\n", uNetbuffertLen, utmp));
	}
	pdlc_header	=	(Dlc_Header*)pbuffer;
	//жethertype,IP账,,PPPOEĻҪر
	if(ntohs(pdlc_header->ethertype)!=0x0800) 
	{	
		DbgPrint(("[send] not ip packet\r\n"));
		if(pbuffer)
		{
			kfree(pbuffer);pbuffer=NULL;
			return ;
		}
	}
	pip_header=(Ip_Header  *)(pbuffer+14);
	pip	=	(PUCHAR)&pip_header->destIP;

	DbgPrint("[send*] ip=%ld.%ld.%ld.%ld.\r\n",pip[0],pip[1], pip[2],pip[3]);
	if(pbuffer)
	{
		kfree(pbuffer);pbuffer=NULL;
	}
	return ;


}

////////////////////////////////////////////////////////////////////////////////
//copy buffer_len of pbuffer bytes to Net_Buffer
NDIS_STATUS copy_buffer_to_netbuffer(PNET_BUFFER pNet_Buffer, PUCHAR pbuffer, ULONG buffer_len)
{
	ULONG			Length;
	NDIS_STATUS		Status = NDIS_STATUS_SUCCESS;
	PUCHAR			SrcMemory;
	PMDL			CurrentMdl;
	ULONG			MdlOffset;
	BOOLEAN			bfirstmdl=TRUE;
	bfirstmdl=TRUE;

	if (NET_BUFFER_DATA_LENGTH(pNet_Buffer)< buffer_len)
	{
		DbgPrint(("[] fuck, what the hell is going on\r\n"));
	}


	//
    // Start copy from current MDL
    //
    CurrentMdl = NET_BUFFER_CURRENT_MDL(pNet_Buffer);
    
    // Data on current MDL may be offset from start of MDL
	// 
	while(CurrentMdl &&buffer_len)
	{
		SrcMemory = MmGetSystemAddressForMdlSafe(CurrentMdl, LowPagePriority);
		Length = MmGetMdlByteCount(CurrentMdl);
		if (!SrcMemory)
		{
			Status = NDIS_STATUS_RESOURCES;
			break;
        }
		if (bfirstmdl)
		{
			MdlOffset = NET_BUFFER_CURRENT_MDL_OFFSET(pNet_Buffer);
			SrcMemory += MdlOffset;
			Length -= MdlOffset;
			bfirstmdl =FALSE;
		}
		buffer_len	=	buffer_len-Length;
		NdisMoveMemory(SrcMemory, pbuffer, Length);
		pbuffer	=	pbuffer+Length;

		CurrentMdl = NDIS_MDL_LINKAGE(CurrentMdl);

		DbgPrint(("[**] copy_buffer_to_netbuffer in while\r\n"));
	}
	return Status;
}
////////////////////////////////////////////////////////////////////////////////

NDIS_STATUS
CopyBytesFromNetBuffer(  PNET_BUFFER        NetBuffer,  PULONG             cbDest, PVOID Dest)
/*++

Routine Description:

    Copies the first cbDest bytes from a NET_BUFFER. In order to show how the various data structures fit together, this 
    implementation copies the data by iterating through the MDLs for the NET_BUFFER. The NdisGetDataBuffer API also allows you
    to copy a contiguous block of data from a NET_BUFFER. 

    Runs at IRQL <= DISPATCH_LEVEL.

Arguments:

    NetBuffer                   The NB to read
    cbDest                      On input, the number of bytes in the buffer Dest
                                On return, the number of bytes actually copied
    Dest                        On return, receives the first cbDest bytes of
                                the network frame in NetBuffer

Return Value:

    None.

Notes:

    If the output buffer is larger than the NB's frame size, *cbDest will
    contain the number of bytes in the frame size.

    If the output buffer is smaller than the NB's frame size, only the first
    *cbDest bytes will be copied (the buffer will receive a truncated copy of
    the frame).

--*/
{
    NDIS_STATUS Status = NDIS_STATUS_SUCCESS;
    //
    // Start copy from current MDL
    //
    PMDL CurrentMdl = NET_BUFFER_CURRENT_MDL(NetBuffer);
    //
    // Data on current MDL may be offset from start of MDL
    //
    ULONG DestOffset = 0;
    while (DestOffset < *cbDest && CurrentMdl)
    {
        //
        // Map MDL memory to System Address Space. LowPagePriority means mapping may fail if 
        // system is low on memory resources. 
        //
        PUCHAR SrcMemory = MmGetSystemAddressForMdlSafe(CurrentMdl, LowPagePriority);
        ULONG Length = MmGetMdlByteCount(CurrentMdl);
        if (!SrcMemory)
        {
            Status = NDIS_STATUS_RESOURCES;
            break;
        }

        if(DestOffset==0)
        {
            //
            // The first MDL segment should be accessed from the current MDL offset
            //
            ULONG MdlOffset = NET_BUFFER_CURRENT_MDL_OFFSET(NetBuffer);
            SrcMemory += MdlOffset;
            Length -= MdlOffset;
        }

        Length = min(Length, *cbDest-DestOffset);

        //
        // Copy Memory
        //
        NdisMoveMemory((PUCHAR)Dest+DestOffset, SrcMemory, Length);
        DestOffset += Length;

        //
        // Get next MDL (if any available) 
        //
        CurrentMdl = NDIS_MDL_LINKAGE(CurrentMdl);
    }

    if(Status == NDIS_STATUS_SUCCESS)
    {
        *cbDest = DestOffset;
    }

    return Status;
}
////////////////////////////////////////////////////////////////////////////////

//У
USHORT checksum(USHORT *buffer,int size)
{
	unsigned long cksum=0;
	while(size>1)
	{
	  cksum+=*buffer++;
	  size-=sizeof(USHORT);
	}
	if(size)
	{
	  cksum+=*(UCHAR *)buffer;
	}
	//32λת16
	while (cksum>>16)
	  cksum=(cksum>>16)+(cksum & 0xffff);
	return (USHORT) (~cksum);
}


//-------------------------------------------------------------------------
// PacketCheckSum
// ݰУ
// :packet-(װõݰָ)
//-------------------------------------------------------------------------
void PacketCheckSum(unsigned char packet[])
{
	PUCHAR		ptmp=NULL;
	Dlc_Header *pdlc_header=NULL; //̫ͷָ
	Ip_Header  *pip_header=NULL;  //IPͷָ
	unsigned short attachsize=0; //ЭͷԼݵܳ
	pdlc_header=(Dlc_Header *)packet;
	//жethertype,IP账
	if(ntohs(pdlc_header->ethertype)!=0x0800) return;
	pip_header=(Ip_Header  *)(packet+14);
	//icmp
	if(0x01==pip_header->proto)
	{
		Icmp_Header	*icmp_hdr	=	NULL;
		pip_header->checksum	=	0;
		pip_header->checksum	=	checksum((unsigned short *)pip_header,20);
		//	icmp_hdr				=	(Icmp_Header	*)((unsigned short *)pip_header+20);
		//	icmp_hdr->i_cksum		=	checksum((unsigned short *)icmp_hdr,sizeof(Icmp_Header));	//Ӳˣ
	}
	//TCP
	if(0x06==pip_header->proto)
	{
		
		Tcp_Header *ptcp_header=NULL; //TCPͷָ
		Tcp_Psd_Header *ptcp_psd_header=NULL;
		
		ptcp_header=(Tcp_Header *)(packet+14+((pip_header->ver_len)&15)*4);
		attachsize=ntohs(pip_header->total_len)-((pip_header->ver_len)&15)*4;
		ptcp_psd_header=(Tcp_Psd_Header *)kmalloc(attachsize+sizeof(Tcp_Psd_Header));
		if(!ptcp_psd_header) return;
		
		ptmp		=	(PUCHAR)ptcp_psd_header;
		memset(ptcp_psd_header,0,attachsize+sizeof(Tcp_Psd_Header));
		//αTCPͷ
		ptcp_psd_header->destip=pip_header->destIP;
		ptcp_psd_header->sourceip=pip_header->sourceIP;
		ptcp_psd_header->mbz=0;
		ptcp_psd_header->ptcl=0x06;
		ptcp_psd_header->tcpl=htons(attachsize);
		//TCPУ
		DbgPrint("[] before %x ,",htons(ptcp_header->chksum));
		ptcp_header->chksum=0;
		memcpy((unsigned char *)ptcp_psd_header+sizeof(Tcp_Psd_Header),
			(unsigned char *)ptcp_header,attachsize);
			
		ptcp_header->chksum=checksum((unsigned short *)ptcp_psd_header,
			attachsize+sizeof(Tcp_Psd_Header));
			
		DbgPrint("[] after %x start byte with %02x,%02x len=%d\r\n",htons(ptcp_header->chksum),((unsigned char *)ptcp_header)[0],((unsigned char *)ptcp_header)[1] ,attachsize+sizeof(Tcp_Psd_Header));
		//ipͷУ
		pip_header->checksum=0;
		pip_header->checksum=checksum((unsigned short *)pip_header,20);
		kfree(ptmp);
		return;
	}
	
	//UDP
	if(0x11==pip_header->proto)
	{
		Udp_Header *pudp_header=NULL; //UDPͷָ
		Udp_Psd_Header *pudp_psd_header=NULL;
		pudp_header=(Udp_Header *)(packet+14+((pip_header->ver_len)&15)*4);
		attachsize=ntohs(pip_header->total_len)-((pip_header->ver_len)&15)*4;
		pudp_psd_header=(Udp_Psd_Header *)kmalloc(attachsize+sizeof(Udp_Psd_Header));
		if(!pudp_psd_header) return;
        memset(pudp_psd_header,0,attachsize+sizeof(Udp_Psd_Header));
		ptmp		=	(PUCHAR)pudp_psd_header;
		//αUDPͷ
		pudp_psd_header->destip=pip_header->destIP;
		pudp_psd_header->sourceip=pip_header->sourceIP;
		pudp_psd_header->mbz=0;
		pudp_psd_header->ptcl=0x11;
		pudp_psd_header->udpl=htons(attachsize);
		
		//UDPУ
		pudp_header->chksum=0;
		memcpy((unsigned char *)pudp_psd_header+sizeof(Udp_Psd_Header),
			(unsigned char *)pudp_header,attachsize);
		pudp_header->chksum=checksum((unsigned short *)pudp_psd_header,
			attachsize+sizeof(Udp_Psd_Header));
		
		//ipͷУ
		pip_header->checksum=0;
		pip_header->checksum=checksum((unsigned short *)pip_header,20);  
		kfree(ptmp);
		return;
	}
	return;
}

////////////////////////////////////////////////////////////////////////////////


unsigned short htons(unsigned short a)
{
	unsigned short b = a;
	b = ( b << 8 );
	a = ( a >> 8 );
	return ( a | b );
};

////////////////////////////////////////////////////////////////////////////////
#include "stdlib.h"
unsigned long inet_addr(const char* name)
{
	int i,j,p;
	int len = strlen(name);
	unsigned long temp_val[4];
	char namesec[10] ;
	
	for(i = 0,j =0,p =0;i < len;i++)
	{
		memset(namesec,0,10);
		if('.' == name[i])
		{
			
			if(p)
				strncpy(namesec,name+p+1,i-p);
			else
				strncpy(namesec,name,i);
			temp_val[j] = atoi(namesec);
			j++;
			p = i;
		}
	}
	
	strncpy(namesec,name+p+1,i-p);
	temp_val[j] = atoi(namesec);
	
	
	return (temp_val[0]|(temp_val[1]<<8)|(temp_val[2]<<16)|(temp_val[3]<<24));
}