/***************************************************************************************
* AUTHOR : zhouws
* DATE   : 2011-1-16
* MODULE : miniport_hook_vista_later.C
* 
* Command: 
*	Source of IOCTRL Sample Driver
*
* Description:
*		Demonstrates communications between USER and KERNEL.
*
****************************************************************************************
* Copyright (C) 2010 zhouws.
****************************************************************************************/

//#######################################################################################
//# I N C L U D E S
//#######################################################################################

#ifndef CXX_MINIPORT_HOOK_VISTA_LATER_H
#	include "miniport_hook_vista_later.h"
#endif

#include "struct.h"
#include "comm_fun.h"
//////////////////////////////////////////////////////////////////////////

UNICODE_STRING       g_RegistryPath;
NDIS_HANDLE        NdisWrapperHandle;
NDIS_HANDLE         DriverHandle = NULL;
ULONG				g_u_mini_driver_block_head;
//////////////////////////////////////////////////////////////////////////
PDRIVER_OBJECT	InitDriverObject();

NTSTATUS start_miniport_hook_vista_later(PDRIVER_OBJECT DriverObject_hi)
{
    NDIS_STATUS                        Status;
    myNDIS51_MINIPORT_CHARACTERISTICS_vista_later      MChars;
    NDIS_STRING                        Name;
	PDRIVER_OBJECT	DriverObject	=	kmalloc( sizeof(DRIVER_OBJECT));
	
	NdisWrapperHandle=NULL;
	DriverHandle	=NULL;
	DriverObject	=	DriverObject_hi;//InitDriverObject();so much things we need to offer
	Status = NDIS_STATUS_SUCCESS;
	g_u_mini_driver_block_head	=	0;
	NdisMInitializeWrapper(&NdisWrapperHandle, DriverObject, &g_RegistryPath, NULL);
	
	NdisZeroMemory(&MChars, sizeof(myNDIS51_MINIPORT_CHARACTERISTICS_vista_later));
	
	MChars.Ndis50Chars.MajorNdisVersion = 5;
	if (GetWindowsVersion()!=Windows_2K)
	{
		MChars.Ndis50Chars.MinorNdisVersion = 1;
	}
	
	/*
	MChars.InitializeHandler = NULL;
	MChars.QueryInformationHandler = NULL;
	MChars.SetInformationHandler = NULL;
	MChars.ResetHandler = NULL;
	MChars.TransferDataHandler = NULL;
	MChars.HaltHandler = NULL;

	MChars.CancelSendPacketsHandler = NULL;
	MChars.PnPEventNotifyHandler = NULL;
    MChars.AdapterShutdownHandler = NULL;
	MChars.SendHandler = NULL;    // MPSend;
	MChars.SendPacketsHandler = NULL;
	*/
	MChars.AdapterShutdownHandler	=	MPAdapterShutdown;
	Status = NdisIMRegisterLayeredMiniport(NdisWrapperHandle,&MChars,sizeof(MChars),&DriverHandle);
	if (Status!=NDIS_STATUS_SUCCESS)
	{
		KdPrint(("[miniport_hook] NdisIMRegisterLayeredMiniport fail, error : 0x%X\n", Status));
		return NDIS_STATUS_SUCCESS;	//㷵
	}
//	__asm int 3
	KdPrint(("[miniport_hook] NdisIMRegisterLayeredMiniport ori_driver_block_list_head :%p, NdisWrapperHandle:0x%X, DriverHandle : 0x%X\n", g_u_mini_driver_block_head, NdisWrapperHandle, DriverHandle));
	DriverHandle	=	(NDIS_HANDLE)((ULONG)DriverHandle+4);
	g_u_mini_driver_block_head	=	*(ULONG*)DriverHandle;	//ȡ
	KdPrint(("[miniport_hook] NdisIMRegisterLayeredMiniport ori_driver_block_list_head :%p\n", g_u_mini_driver_block_head));
//	__asm int 3
	NdisIMDeregisterLayeredMiniport(DriverHandle);	//ȡע
	NdisTerminateWrapper(NdisWrapperHandle, NULL);
	if (g_u_mini_driver_block_head==0)
	{
		KdPrint(("[miniport_hook] ungeiliable ...fuck!!\r\n"));
	}
	miniport_hook_vista_later(g_u_mini_driver_block_head);
	return 1;
}
//////////////////////////////////////////////////////////////////////////
//#######################################################################################
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@@@@@@@@				D R I V E R   E N T R Y   P O I N T						 @@@@@@@@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//#######################################################################################
NTSTATUS
DriverEntry(IN PDRIVER_OBJECT pDriverObj, IN PUNICODE_STRING pRegistryString)
{
	NTSTATUS		status = STATUS_SUCCESS;
	NTSTATUS			Status_createthread = STATUS_SUCCESS;  
	HANDLE				hthread;
	UNICODE_STRING  ustrLinkName;
	UNICODE_STRING  ustrDevName;  
	PDEVICE_OBJECT  pDevObj;
	int i = 0;
	
    dprintf("[miniport_hook_vista_later] EasySys Sample Driver\r\n"
            "[miniport_hook_vista_later] Compiled %s %s\r\n[miniport_hook_vista_later] In DriverEntry : %wZ\r\n",
			__DATE__, __TIME__, pRegistryString);
	g_RegistryPath	=*pRegistryString;

	Status_createthread = PsCreateSystemThread(&hthread,
		THREAD_ALL_ACCESS,
		NULL,
		NULL,
		NULL,
		(PKSTART_ROUTINE) start_miniport_hook_vista_later,
		pDriverObj
		);
	if (Status_createthread!=NDIS_STATUS_SUCCESS)
	{
		KdPrint(("[miniport_hook] PsCreateSystemThread start_miniport_hook Error Code = 0x%X\n", Status_createthread));
	}
	// Register dispatch routines
/*
	for(i = 0; i < IRP_MJ_MAXIMUM_FUNCTION; i++)
	{
		pDriverObj->MajorFunction[i] = DispatchCommon;  
	}
*/
	pDriverObj->MajorFunction[IRP_MJ_CREATE] = DispatchCreate;
	pDriverObj->MajorFunction[IRP_MJ_CLOSE] = DispatchClose;

	// Dispatch routine for communications
	pDriverObj->MajorFunction[IRP_MJ_DEVICE_CONTROL] = DispatchDeviceControl;

	// Unload routine
	pDriverObj->DriverUnload = DriverUnload;

	// Initialize the device name.
	RtlInitUnicodeString(&ustrDevName, DEVICE_NAME);

	// Create the device object and device extension
	status = IoCreateDevice(pDriverObj, 
				0,
				&ustrDevName, 
				FILE_DEVICE_UNKNOWN,
				0,
				FALSE,
				&pDevObj);

	if(!NT_SUCCESS(status))
	{
		dprintf("[miniport_hook_vista_later] Error, IoCreateDevice = 0x%x\r\n", status);
		return status;
	}

    //// Get a pointer to our device extension
    //deviceExtension = (PDEVICE_EXTENSION) deviceObject->DeviceExtension;

    //// Save a pointer to the device object
    //deviceExtension->DeviceObject = deviceObject;

	if(IoIsWdmVersionAvailable(1,0x10))
	{
		//ַ֧ûԵϵͳ
		RtlInitUnicodeString(&ustrLinkName, SYMBOLIC_LINK_GLOBAL_NAME);
	}
	else
	{
		//֧
		RtlInitUnicodeString(&ustrLinkName, SYMBOLIC_LINK_NAME);
	}
	
	// Create a symbolic link to allow USER applications to access it. 
	status = IoCreateSymbolicLink(&ustrLinkName, &ustrDevName);  
	
	if(!NT_SUCCESS(status))
	{
		dprintf("[miniport_hook_vista_later] Error, IoCreateSymbolicLink = 0x%x\r\n", status);
		
		IoDeleteDevice(pDevObj); 
		return status;
	}	

	//
	//	TODO: Add initialization code here.
	//

    //// Tell the I/O Manger to do BUFFERED IO
    //deviceObject->Flags |= DO_BUFFERED_IO;

    //// Save the DeviveObject
    //deviceExtension->DeviceObject = deviceObject;

	dprintf("[miniport_hook_vista_later] DriverEntry Success\r\n");

	return STATUS_SUCCESS;
}

VOID
DriverUnload(IN PDRIVER_OBJECT pDriverObj)
{	
	UNICODE_STRING strLink;

	// Unloading - no resources to free so just return.
	dprintf("[miniport_hook_vista_later] Unloading...\r\n");;	

	//
	// TODO: Add uninstall code here.
	//
	
	// Delete the symbolic link
	RtlInitUnicodeString(&strLink, SYMBOLIC_LINK_NAME);
	IoDeleteSymbolicLink(&strLink);

	// Delete the DeviceObject
	IoDeleteDevice(pDriverObj->DeviceObject);

	dprintf("[miniport_hook_vista_later] Unloaded Success\r\n");
	unhook();
	return;
}

NTSTATUS
DispatchCreate(IN PDEVICE_OBJECT pDevObj, IN PIRP pIrp)
{
	pIrp->IoStatus.Status = STATUS_SUCCESS;
	pIrp->IoStatus.Information = 0;

	dprintf("[miniport_hook_vista_later] IRP_MJ_CREATE\r\n");

	IoCompleteRequest(pIrp, IO_NO_INCREMENT);

	return STATUS_SUCCESS;
}


NTSTATUS
DispatchClose(IN PDEVICE_OBJECT pDevObj, IN PIRP pIrp)
{
	pIrp->IoStatus.Status = STATUS_SUCCESS;
	pIrp->IoStatus.Information = 0;

	dprintf("[miniport_hook_vista_later] IRP_MJ_CLOSE\r\n");

	IoCompleteRequest(pIrp, IO_NO_INCREMENT);

	// Return success
	return STATUS_SUCCESS;
}

NTSTATUS
DispatchCommon(IN PDEVICE_OBJECT pDevObj, IN PIRP pIrp)
{
	pIrp->IoStatus.Status = STATUS_SUCCESS;
	pIrp->IoStatus.Information = 0L;

	dprintf("[miniport_hook_vista_later] Common Dispatch\r\n");

	IoCompleteRequest( pIrp, 0 );

	// Return success
	return STATUS_SUCCESS;
}

NTSTATUS 
DispatchDeviceControl(IN PDEVICE_OBJECT pDevObj, IN PIRP pIrp)
{
	NTSTATUS status               = STATUS_INVALID_DEVICE_REQUEST;	 // STATUS_UNSUCCESSFUL
	PIO_STACK_LOCATION pIrpStack  = IoGetCurrentIrpStackLocation(pIrp);
	ULONG uIoControlCode          = 0;
	PVOID pIoBuffer				  = NULL;
	ULONG uInSize                 = 0;
	ULONG uOutSize                = 0;

	// Get the IoCtrl Code
	uIoControlCode = pIrpStack->Parameters.DeviceIoControl.IoControlCode;

	pIoBuffer = pIrp->AssociatedIrp.SystemBuffer;
	uInSize = pIrpStack->Parameters.DeviceIoControl.InputBufferLength;
	uOutSize = pIrpStack->Parameters.DeviceIoControl.OutputBufferLength;

	switch(uIoControlCode)
	{
		case IOCTL_HELLO_WORLD:
			{			
				dprintf("[miniport_hook_vista_later] Hello World!\r\n");

				// Return success
				status = STATUS_SUCCESS;
			}
			break;

		case IOCTRL_REC_FROM_APP:
			{
				// Receive data form Application
				dprintf("[miniport_hook_vista_later] IOCTRL_REC_FROM_APP\r\n");

				// Do we have any data?
				if( uInSize > 0 )
				{
					dprintf("[miniport_hook_vista_later] Get Data from App: %s\r\n", pIoBuffer);
				}

				// Return success
				status = STATUS_SUCCESS;
			}
			break;

		case IOCTRL_SEND_TO_APP:
			{
				// Send data to Application
				dprintf("[miniport_hook_vista_later] IOCTRL_SEND_TO_APP\r\n");
			
				// If we have enough room copy the data upto the App - note copy the terminating character as well...
				if( uOutSize >= strlen( DATA_TO_APP ) + 1 )
				{
					RtlCopyMemory(  pIoBuffer,
									DATA_TO_APP, 
									strlen( DATA_TO_APP ) + 1 );

					// Update the length for the App
					pIrp->IoStatus.Information = strlen( DATA_TO_APP ) + 1;

					dprintf("[miniport_hook_vista_later] Send Data to App: %s\r\n", pIoBuffer);
					
					// Return success
					status = STATUS_SUCCESS;
				}
			}
			break;
			
		//
		// TODO: Add execute code here.
		//

		default:
			{
				// Invalid code sent
				dprintf("[miniport_hook_vista_later] Unknown IOCTL: 0x%X (%04X,%04X)\r\n", 
                                          uIoControlCode,
                                          DEVICE_TYPE_FROM_CTL_CODE(uIoControlCode),
                                          IoGetFunctionCodeFromCtlCode(uIoControlCode));
				status = STATUS_INVALID_PARAMETER;	
			}
			break;
	}

	if(status == STATUS_SUCCESS)
	{
		pIrp->IoStatus.Information = uOutSize;
	}
	else
	{
		pIrp->IoStatus.Information = 0;
	}

	// Complete the I/O Request
	pIrp->IoStatus.Status = status;

	IoCompleteRequest(pIrp, IO_NO_INCREMENT);

	return status;
}


//
// TODO: Add your module definitions here.
//

VOID
MPAdapterShutdown(
    IN NDIS_HANDLE                MiniportAdapterContext
    )
/*++

Routine Description:

    This handler is called to notify us of an impending system shutdown.

Arguments:

    MiniportAdapterContext    - pointer to ADAPT structure

Return Value:

    None
--*/
{
    UNREFERENCED_PARAMETER(MiniportAdapterContext);
    
    return;
}

PDRIVER_OBJECT  InitDriverObject()
{
	PDRIVER_OBJECT	m_DriverObject;
    ULONG   dwSize ;
	int i;
	dwSize= sizeof ( DRIVER_OBJECT ) + sizeof (DRIVER_EXTENSION);
    
	m_DriverObject = (DRIVER_OBJECT*)kmalloc( dwSize );
	
	if ( m_DriverObject )
	{
		RtlZeroMemory ( m_DriverObject ,  dwSize );
		
		m_DriverObject->DriverExtension = (PDRIVER_EXTENSION) (m_DriverObject + 1);
		m_DriverObject->DriverExtension->DriverObject = m_DriverObject;
		
		for ( i = 0; i <= IRP_MJ_MAXIMUM_FUNCTION; i++ )
		{
			m_DriverObject->MajorFunction[i] = DispatchDeviceControl;
		}
			
		m_DriverObject->Type            = 0;  
		m_DriverObject->Size            = sizeof( DRIVER_OBJECT );        
		m_DriverObject->DriverSection   = NULL;
		m_DriverObject->DriverStart     = NULL;
		m_DriverObject->DriverSize      = 0;
 
	}    
}

/* EOF */
