//sha1㷨ժ

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <errno.h>
#include <Windows.h>

/****************************************************************
* a0 a0 a0 a0 a0 a1 a1 a1 | a1 a1 a2 a2 a2 a2 a2 a3 | a3 a3 a3 a3 a4 a4 a4 a4 | a4 a5 a5 a5 a5 a5 a6 a6 | a6 a6 a6 a7 a7 a7 a7 a7
*****************************************************************/
typedef unsigned char BYTE;

typedef unsigned int u32;
typedef struct {
    u32  h0,h1,h2,h3,h4;
    u32  nblocks;
    unsigned char buf[64];
    int  count;
} SHA1_CONTEXT;

void sha1_init( SHA1_CONTEXT *hd );
void sha1_write( SHA1_CONTEXT *hd, unsigned char *inbuf, size_t inlen);
void sha1_final(SHA1_CONTEXT *hd);

BYTE encrypt_username[20];
char keygenme_serial[40];

char* const_str_1 = "Tencent";
char* const_str_2 = "ABCDEFGHJKMNPQRSTVWXYZ1234567890";
char const_char = '=';
DWORD const_value_1 = 0xB1CAB1CA;
DWORD const_value_2 = 0xCCBFCCBF;
DWORD const_value_3 = 0xBFB2D6BE;
DWORD const_value_4 = 0xF8C7D8B5;
DWORD const_value_5 = 0xEEC7BCCD;


void sha1_username(char* username, int len)
{
	BYTE content[44];
	memset(content,0,sizeof(content));
	DWORD volumeSerialNumber;
	GetVolumeInformationA("C:\\", 0, 0, &volumeSerialNumber, 0, 0, 0, 0);
	memcpy(content,username,len);
	memcpy(content+len,&volumeSerialNumber,4);
	memcpy(content+len+4,const_str_1,strlen(const_str_1)+1);
	int content_len = len + strlen(const_str_1) + 4;

	SHA1_CONTEXT ctx;
	sha1_init (&ctx);
	sha1_write (&ctx, content, content_len);
	sha1_final (&ctx);
	memcpy(encrypt_username,ctx.buf,20);
}
void sha1_username_to_serial()
{
	BYTE encrypt_serial[32];

	int j=0;
	for(int i=0;i<20; i=i+5)
	{
		BYTE b0 = encrypt_username[i];
		BYTE b1 = encrypt_username[i+1];
		BYTE b2 = encrypt_username[i+2];
		BYTE b3 = encrypt_username[i+3];
		BYTE b4 = encrypt_username[i+4];

		encrypt_serial[j]=b0>>3;
		encrypt_serial[j+1]=((b0<<2)&0x1f)|(b1>>6);
		encrypt_serial[j+2]=(b1>>1)&0x1f;
		encrypt_serial[j+3]=((b1<<4)&0x1f) | (b2>>4);
		encrypt_serial[j+4]=((b2<<1)&0x1f)| (b3>>7);
		encrypt_serial[j+5]=(b3>>2)&0x1f;
		encrypt_serial[j+6]=((b3<<3)&0x1f)|(b4>>5);
		encrypt_serial[j+7]=b4&0x1f;
		j=j+8;
	}
	int n=0;
	for(int k=0;k<32;++k)
	{
		if(n==8 || n==17 || n==26)
		{
			keygenme_serial[n++] = '-';
		}
		keygenme_serial[n++]=const_str_2[encrypt_serial[k]];
	}
}
int main(int argc, char** argv)
{
	if(argc <= 1)
	{
		printf("please input User Name!\n");
		return 1;
	}
	if(strlen(argv[1])>32)
	{
		printf("User name is too long!\n");
		return 1;
	}
	char* username = argv[1];
	sha1_username(username,strlen(username));
	sha1_username_to_serial();
	printf("User Name=%s\n",username);
	printf("License Code=%s\n",keygenme_serial);
	return 0;
}

//**************sha1 ,滻5************************
/* SHA-1 coden take from gnupg 1.3.92. */

/****************
 * Rotate a 32 bit integer by n bytes
 ****************/
#define rol(x,n) ( ((x) << (n)) | ((x) >> (32-(n))) )

void sha1_init( SHA1_CONTEXT *hd )
{
    hd->h0 = 0xB1CAB1CA;
    hd->h1 = 0xCCBFCCBF;
    hd->h2 = 0xBFB2D6BE;
    hd->h3 = 0xF8C7D8B5;
    hd->h4 = 0xEEC7BCCD;
    hd->nblocks = 0;
    hd->count = 0;
}


/*
 * Transform the message X which consists of 16 32-bit-words
 */
 void transform( SHA1_CONTEXT *hd, unsigned char *data )
{
    u32 a,b,c,d,e,tm;
    u32 x[16];

    /* get values from the chaining vars */
    a = hd->h0;
    b = hd->h1;
    c = hd->h2;
    d = hd->h3;
    e = hd->h4;

#ifdef BIG_ENDIAN_HOST
    memcpy( x, data, 64 );
#else
    { int i;
        unsigned char *p2;
        for(i=0, p2=(unsigned char*)x; i < 16; i++, p2 += 4 ) {
            p2[3] = *data++;
            p2[2] = *data++;
            p2[1] = *data++;
            p2[0] = *data++;
        }
    }
#endif


#define K1  0x5A827999L
#define K2  0x6ED9EBA1L
#define K3  0x8F1BBCDCL
#define K4  0xCA62C1D6L
#define F1(x,y,z)   ( z ^ ( x & ( y ^ z ) ) )
#define F2(x,y,z)   ( x ^ y ^ z )
#define F3(x,y,z)   ( ( x & y ) | ( z & ( x | y ) ) )
#define F4(x,y,z)   ( x ^ y ^ z )


#define M(i) ( tm =   x[i&0x0f] ^ x[(i-14)&0x0f]    \
               ^ x[(i-8)&0x0f] ^ x[(i-3)&0x0f]      \
               , (x[i&0x0f] = rol(tm,1)) )

#define R(a,b,c,d,e,f,k,m)  do { e += rol( a, 5 )   \
            + f( b, c, d )                          \
            + k                                     \
            + m;                                    \
        b = rol( b, 30 );                           \
    } while(0)
    R( a, b, c, d, e, F1, K1, x[ 0] );
    R( e, a, b, c, d, F1, K1, x[ 1] );
    R( d, e, a, b, c, F1, K1, x[ 2] );
    R( c, d, e, a, b, F1, K1, x[ 3] );
    R( b, c, d, e, a, F1, K1, x[ 4] );
    R( a, b, c, d, e, F1, K1, x[ 5] );
    R( e, a, b, c, d, F1, K1, x[ 6] );
    R( d, e, a, b, c, F1, K1, x[ 7] );
    R( c, d, e, a, b, F1, K1, x[ 8] );
    R( b, c, d, e, a, F1, K1, x[ 9] );
    R( a, b, c, d, e, F1, K1, x[10] );
    R( e, a, b, c, d, F1, K1, x[11] );
    R( d, e, a, b, c, F1, K1, x[12] );
    R( c, d, e, a, b, F1, K1, x[13] );
    R( b, c, d, e, a, F1, K1, x[14] );
    R( a, b, c, d, e, F1, K1, x[15] );
    R( e, a, b, c, d, F1, K1, M(16) );
    R( d, e, a, b, c, F1, K1, M(17) );
    R( c, d, e, a, b, F1, K1, M(18) );
    R( b, c, d, e, a, F1, K1, M(19) );
    R( a, b, c, d, e, F2, K2, M(20) );
    R( e, a, b, c, d, F2, K2, M(21) );
    R( d, e, a, b, c, F2, K2, M(22) );
    R( c, d, e, a, b, F2, K2, M(23) );
    R( b, c, d, e, a, F2, K2, M(24) );
    R( a, b, c, d, e, F2, K2, M(25) );
    R( e, a, b, c, d, F2, K2, M(26) );
    R( d, e, a, b, c, F2, K2, M(27) );
    R( c, d, e, a, b, F2, K2, M(28) );
    R( b, c, d, e, a, F2, K2, M(29) );
    R( a, b, c, d, e, F2, K2, M(30) );
    R( e, a, b, c, d, F2, K2, M(31) );
    R( d, e, a, b, c, F2, K2, M(32) );
    R( c, d, e, a, b, F2, K2, M(33) );
    R( b, c, d, e, a, F2, K2, M(34) );
    R( a, b, c, d, e, F2, K2, M(35) );
    R( e, a, b, c, d, F2, K2, M(36) );
    R( d, e, a, b, c, F2, K2, M(37) );
    R( c, d, e, a, b, F2, K2, M(38) );
    R( b, c, d, e, a, F2, K2, M(39) );
    R( a, b, c, d, e, F3, K3, M(40) );
    R( e, a, b, c, d, F3, K3, M(41) );
    R( d, e, a, b, c, F3, K3, M(42) );
    R( c, d, e, a, b, F3, K3, M(43) );
    R( b, c, d, e, a, F3, K3, M(44) );
    R( a, b, c, d, e, F3, K3, M(45) );
    R( e, a, b, c, d, F3, K3, M(46) );
    R( d, e, a, b, c, F3, K3, M(47) );
    R( c, d, e, a, b, F3, K3, M(48) );
    R( b, c, d, e, a, F3, K3, M(49) );
    R( a, b, c, d, e, F3, K3, M(50) );
    R( e, a, b, c, d, F3, K3, M(51) );
    R( d, e, a, b, c, F3, K3, M(52) );
    R( c, d, e, a, b, F3, K3, M(53) );
    R( b, c, d, e, a, F3, K3, M(54) );
    R( a, b, c, d, e, F3, K3, M(55) );
    R( e, a, b, c, d, F3, K3, M(56) );
    R( d, e, a, b, c, F3, K3, M(57) );
    R( c, d, e, a, b, F3, K3, M(58) );
    R( b, c, d, e, a, F3, K3, M(59) );
    R( a, b, c, d, e, F4, K4, M(60) );
    R( e, a, b, c, d, F4, K4, M(61) );
    R( d, e, a, b, c, F4, K4, M(62) );
    R( c, d, e, a, b, F4, K4, M(63) );
    R( b, c, d, e, a, F4, K4, M(64) );
    R( a, b, c, d, e, F4, K4, M(65) );
    R( e, a, b, c, d, F4, K4, M(66) );
    R( d, e, a, b, c, F4, K4, M(67) );
    R( c, d, e, a, b, F4, K4, M(68) );
    R( b, c, d, e, a, F4, K4, M(69) );
    R( a, b, c, d, e, F4, K4, M(70) );
    R( e, a, b, c, d, F4, K4, M(71) );
    R( d, e, a, b, c, F4, K4, M(72) );
    R( c, d, e, a, b, F4, K4, M(73) );
    R( b, c, d, e, a, F4, K4, M(74) );
    R( a, b, c, d, e, F4, K4, M(75) );
    R( e, a, b, c, d, F4, K4, M(76) );
    R( d, e, a, b, c, F4, K4, M(77) );
    R( c, d, e, a, b, F4, K4, M(78) );
    R( b, c, d, e, a, F4, K4, M(79) );

    /* Update chaining vars */
    hd->h0 += a;
    hd->h1 += b;
    hd->h2 += c;
    hd->h3 += d;
    hd->h4 += e;
}


/* Update the message digest with the contents
 * of INBUF with length INLEN.
 */
void sha1_write( SHA1_CONTEXT *hd, unsigned char *inbuf, size_t inlen)
{
    if( hd->count == 64 ) { /* flush the buffer */
        transform( hd, hd->buf );
        hd->count = 0;
        hd->nblocks++;
    }
    if( !inbuf )
        return;
    if( hd->count ) {
        for( ; inlen && hd->count < 64; inlen-- )
            hd->buf[hd->count++] = *inbuf++;
        sha1_write( hd, NULL, 0 );
        if( !inlen )
            return;
    }

    while( inlen >= 64 ) {
        transform( hd, inbuf );
        hd->count = 0;
        hd->nblocks++;
        inlen -= 64;
        inbuf += 64;
    }
    for( ; inlen && hd->count < 64; inlen-- )
        hd->buf[hd->count++] = *inbuf++;
}


/* The routine final terminates the computation and
 * returns the digest.
 * The handle is prepared for a new cycle, but adding bytes to the
 * handle will the destroy the returned buffer.
 * Returns: 20 bytes representing the digest.
 */

void sha1_final(SHA1_CONTEXT *hd)
{
    u32 t, msb, lsb;
    unsigned char *p;

    sha1_write(hd, NULL, 0); /* flush */;

    t = hd->nblocks;
    /* multiply by 64 to make a byte count */
    lsb = t << 6;
    msb = t >> 26;
    /* add the count */
    t = lsb;
    if( (lsb += hd->count) < t )
        msb++;
    /* multiply by 8 to make a bit count */
    t = lsb;
    lsb <<= 3;
    msb <<= 3;
    msb |= t >> 29;

    if( hd->count < 56 ) { /* enough room */
        hd->buf[hd->count++] = 0x80; /* pad */
        while( hd->count < 56 )
            hd->buf[hd->count++] = 0;  /* pad */
    }
    else { /* need one extra block */
        hd->buf[hd->count++] = 0x80; /* pad character */
        while( hd->count < 64 )
            hd->buf[hd->count++] = 0;
        sha1_write(hd, NULL, 0);  /* flush */;
        memset(hd->buf, 0, 56 ); /* fill next block with zeroes */
    }
    /* append the 64 bit count */
    hd->buf[56] = msb >> 24;
    hd->buf[57] = msb >> 16;
    hd->buf[58] = msb >>  8;
    hd->buf[59] = msb	   ;
    hd->buf[60] = lsb >> 24;
    hd->buf[61] = lsb >> 16;
    hd->buf[62] = lsb >>  8;
    hd->buf[63] = lsb	   ;
    transform( hd, hd->buf );

    p = hd->buf;
#ifdef BIG_ENDIAN_HOST
#define X(a) do { *(u32*)p = hd->h##a ; p += 4; } while(0)
#else /* little endian */
#define X(a) do { *p++ = hd->h##a >> 24; *p++ = hd->h##a >> 16; \
        *p++ = hd->h##a >> 8; *p++ = hd->h##a; } while(0)
#endif
    X(0);
    X(1);
    X(2);
    X(3);
    X(4);
#undef X
}