#include <stddef.h>
#include "dll.h"
#include "dllext.h"
#include "HyColorText.h"
#include "HyDbgHelp.h"

int strcmpi(const char*,const char*);
int getch(void);

static SvrHnds g_shs = {0};
//NTļȫ·
static char g_KernelFilePath[MAX_PATH] = {0};
//NTļ,׺.exe
static char g_KernelFileName[32] = {0};
//DbgHelp ModuleNTļļػַ
static DWORD64 g_KernelBaseLD = 0x0LLU;
//NTʵϵͳʱĻַ
static PVOID g_KernelBaseRT = NULL;
//ʱSSDTĵַ
static PVOID g_pSSDT = NULL;
//ʱSSDT Shadowĵַ
static PVOID g_pSSDTSdw = NULL;
//SSDT.BaseSSDTSdw.Base
static PVOID g_SSDTBases[2] = {NULL,NULL};
//Win32k.sysļȫ·
static char g_Win32kFilePath[MAX_PATH] = {0};
//Win32k.sysĲ׺
static char *g_pWin32kFileName = "win32k";
//Win32k DgbHelpʱַ
static DWORD64 g_Win32kBaseLD = 0x0LLU;
//Win32kϵͳʱַ
static PVOID g_Win32kBaseRT = NULL;
//Ƿ׼̨
bool g_bIsStdOut = false;

//ȴûesctrue򷵻false
bool WaitAnyKey(size_t i)
{
	//Ǳ׼̨򲻵ȴûس
	if(!g_bIsStdOut) return false;
	if(!(i%24) && i)
	{
		HyPrintColorText("press any key to continue...[ESC to QUIT]",\
			CLR_TEXT_BRIGHT|CLR_TEXT_GREEN);
		fflush(stdin);
		//getcharܲESCgetchF1,F2֮ļʱ
		//Ჶ2Σ顣
		char c = getch();
		//printf("[%s]%02x\n",__func__,c);
		if(c == 0x0D) puts("");
		if(c == 0x1B) return true;
	}
	return false;
}

//ʱںеĵַתΪںļеĶӦƫƵַ
inline PVOID GetKernelOffsetLD(PVOID AddrRT)
{
	return (PVOID)((ULONG)AddrRT - (ULONG)g_KernelBaseRT + (ULONG)g_KernelBaseLD);
}

//ںļмصĵַתΪʱںƫƵַ
inline PVOID GetKernelOffsetRT(PVOID AddrLD)
{
	return (PVOID)((ULONG)AddrLD - (ULONG)g_KernelBaseLD + (ULONG)g_KernelBaseRT);
}

static PVOID GetSysModListAddr(void)
{
	PVOID SysModListAddr = HyGetSymAddrRaw(g_KernelBaseLD,\
		"PsLoadedModuleList");
	if(!SysModListAddr)
	{
		PRINT("[%s]err : Get PsLoadedModuleList Addr Failed!\n",\
			__func__);
		goto QUIT;
	}
	//SSDTSdwʵʱƫ
	SysModListAddr = GetKernelOffsetRT(SysModListAddr);
QUIT:
	return SysModListAddr;
}

//ں˱ϵͳģб,鿴ҪDebugView
static void EnumSysMod(void)
{
	PVOID SysModListAddr = GetSysModListAddr();
	if(!SysModListAddr) goto QUIT;
	PRINT("[%s]SysModListAddr is 0X%08X\n",__func__,SysModListAddr);
	HyEnumSysMod(&g_shs,SysModListAddr);
QUIT:
	return;
}

//ӡMMйصں˱
static void HyPrintSysMmVal(void)
{
	HySymPrintStructElements(g_KernelBaseLD,"_MMSUPPORT");
	//PrintErr();
}

//ӡϵͳں˱ֵ
static void HyPrintSysVal(void)
{
	HyPrintSysMmVal();
}

//ӡϵͳģ
static void HyPrintSysMod(void)
{
	HyGetRTModInfo("Print*",(PVOID)100);
}

//ϵͳ
static const char *GetSysSegType(PGATE pGate)
{
	if(!pGate->P)
		return "---";
	
	//DT==0ʾϵͳ,DT==1ʾ洢
	if(pGate->DT)
		return "NOT SYSSEG!";
	
	switch(pGate->Type)
	{
	case 0:case 8:case 0xA:case 0xD:
	default:return "Unknow SysSeg";
	case 1:	return "Avail 286TSS";
	case 2:	return "LDT";
	case 3:	return "Busy 286TSS";
	case 4:	return "286 Call Gate";
	case 5:	return "Task Gate";
	case 6:	return "286 Interrupt Gate";
	case 7:	return "286 Trap Gate";
	case 9:	return "Avail 386TSS";
	case 0xB:return "Busy 386TSS";
	case 0xC:return "386 Call Gate";
	case 0xE:return "386 Interrupt Gate";
	case 0xF:return "386 Trap Gate";
	}
}

//ӡϵͳIDT
static void HyPrintIDT(void)
{
	//RING3ȡIDT(sidt)VMwareл!!!
	GATE Gates[256] = {{0}};
	HyGetIDT(&g_shs,Gates,sizeof(Gates));
	
	PSYMBOL_INFO pSI = malloc(sizeof(SYMBOL_INFO)+MAX_SYM_NAME);
	if(!pSI) goto QUIT;
	pSI->SizeOfStruct = sizeof(SYMBOL_INFO);
	pSI->MaxNameLen = MAX_SYM_NAME;
	
	puts("  NUM      OFFSET   DPL  P       TYPE             SYMBOL");
	for(size_t i = 0;i < 256;++i)
	{
		if(!HySymFromAddrRaw((DWORD64)(DWORD)GetKernelOffsetLD(\
			(PVOID)FULLOFFSET(Gates[i])),\
			pSI))
		{
			strcpy(pSI->Name,"<Unknow Symbol>");
		}
		
		printf("%04d[%02X] 0X%08X  %d   %-2s  %-18s  %-15s\n",i,\
			i,FULLOFFSET(Gates[i]),\
			Gates[i].DPL,Gates[i].P?"P":"NP",\
			GetSysSegType(&Gates[i]),pSI->Name);
		//ûesc˳ӡ
		if(WaitAnyKey(i)) break;
	}
QUIT:
	free(pSI);
}

//ȡô洢εĶν
static DWORD GetSegLimit(PSEGMENT pSeg)
{
	DWORD dwRet = pSeg->G?0x1000:1;
	return dwRet * FULLLIMIT(*pSeg) + dwRet - 1;
}

//ȡö
static const char *GetSegAttr(PSEGMENT pSeg)
{
	static char szRet[32];
	if(!pSeg->P)
		return "---";
	else if(!pSeg->DT)	//ϵͳ
		return GetSysSegType((PGATE)pSeg);
	else
	{
		//洢
		bool bIsCode = false;
		strcpy(szRet,"");
		if(pSeg->Type & 1)
			strcat(szRet,"A");		//ѷ
		
		if(pSeg->Type & 1<<3)	
		{
			strcat(szRet," CS");	//
			bIsCode = true;
		}
		else
			strcat(szRet," DS");	//ݶ
		
		if(pSeg->Type & 1<<1 && bIsCode)	//Ǵ1λλʾɶ
			strcat(szRet," R");
		else if(pSeg->Type & 1<<1 && !bIsCode)
			strcat(szRet," W");				//ݶ1λλʾдݶ
		
		if(pSeg->Type & 1<<2 && bIsCode)
			strcat(szRet," C");		//һ´
		else if(pSeg->Type & 1<<2 && !bIsCode)
			strcat(szRet," H->L");	//ݶδӸչ
		return szRet;
	}
}

//ӡϵͳGDT
static void HyPrintGDT(void)
{
	//RING3ȡGDT(sgdt)VMwareл!!!
	SEGMENT Segs[128] = {{0}};
	HyGetGDT(&g_shs,Segs,sizeof(Segs));
	
	puts("  NUM       BASE       LIMIT   DPL P  BEAD TYPE    ATTRIBUTE");
	for(size_t i = 0;i < 128;++i)
	{
		printf("%04d[%02X] 0X%08X 0X%08X  %d  %s  %s  TYPE:%X  %s\n",i,\
			i,FULLBASE(Segs[i]),\
			GetSegLimit(&Segs[i]),Segs[i].DPL,Segs[i].P?"P":"NP",\
			Segs[i].G?"4KB":"1B",Segs[i].Type,\
			GetSegAttr(&Segs[i]));
		//ûesc˳ӡ
		if(WaitAnyKey(i)) break;
	}
}

//ɫӡSSDTÿһĿ
static void PrintSSDTItem(size_t id,PVOID OrgAddr,PVOID RealAddr,\
	const char *SvrName)
{
	char buf[256];
	
	if(!SvrName) return;
	printf("[%04d] 0x%08X ",id,OrgAddr);
	if(OrgAddr != RealAddr)
	{
		//ԭʼַʵʷַһ£˵HOOKED
		//ɫĿʾ÷Ŀ
		snprintf(buf,sizeof(buf),"*0x%08X  %s\n",(UINT)RealAddr,SvrName);
		//Ǳ׼ HyPrintColorText ʵļ컻
		//printf!
		if(g_bIsStdOut)
			HyPrintColorText(buf,CLR_TEXT_RED|CLR_TEXT_BRIGHT);
		else
			printf(buf);
	}
	else
		printf("0x%08X  %s\n",RealAddr,SvrName);
}

//PEļָεļƫƵַ
//ΪWin32kֵ֧SSDTSdwWin32k.sysļеƫƵַ
//ݶεļƫ0(2k,xp,2k3,win7)
//עĳЩ汾xp(sp2)⣬ųŵԭ
static PVOID GetPESectionOffset(FILE *pf,const char *SectionName)
{	
	PVOID RetDO = NULL;
	size_t SectionCount = 0;
	PVOID pNTHeader;
	IMAGE_NT_HEADERS ImgNTHeaders;
	
	if(!SectionName) return RetDO;
	//λIMAGE_NT_HEADERSṹλϢ
	fseek(pf,offsetof(IMAGE_DOS_HEADER,e_lfanew),SEEK_SET);
	//ȡIMAGE_NT_HEADERSλ
	fread(&pNTHeader,sizeof(long),1,pf);
	//ļָ붨λIMAGE_NT_HEADERSλ
	fseek(pf,(long)pNTHeader,SEEK_SET);
	//ȡIMAGE_NT_HEADERSṹ
	fread(&ImgNTHeaders,sizeof(IMAGE_NT_HEADERS),1,pf);
	//ȡSECTIONĿ
	SectionCount = ImgNTHeaders.FileHeader.NumberOfSections;
	PRINT("[%s]msg : SectionCount is %d\n",__func__,SectionCount);
	
	//ҪʽfseekSECTION TABLEǰfreadѾƶȷƫˡ
	//fseek(pf,(long)sizeof(IMAGE_NT_HEADERS),SEEK_CUR);
	IMAGE_SECTION_HEADER ImgSecHeaders[SectionCount];
	
	//ȡSECTION
	fread(ImgSecHeaders,sizeof(ImgSecHeaders),1,pf);
	for(size_t i = 0;i<SectionCount;++i)
	{
		if(strstr(ImgSecHeaders[i].Name,SectionName))
		{
			RetDO = (PVOID)ImgSecHeaders[i].PointerToRawData;
			break;
		}
	}
	return RetDO;
}

//Win32k.sysлԭʼSSDTSdwеĿ
static bool GetSSDTSdwOrg(PVOID buf,size_t size)
{
	bool bRet = false;
	if(!buf || !size) goto QUIT;
	FILE *pf = fopen(g_Win32kFilePath,"rb");
	if(!pf) goto QUIT;
	
	//ȡWin32k.sysdataεļƫ,SSDTSdwͷڸƫơ
	PVOID SSDTSdwFileOffset = GetPESectionOffset(pf,".data");
	if(!SSDTSdwFileOffset) goto QUIT;
	
	fseek(pf,(long)SSDTSdwFileOffset,SEEK_SET);
	fread(buf,size,1,pf);
	bRet = true;
QUIT:
	if(pf) fclose(pf);
	return bRet;
}

//ںļлԭʼSSDTеĿ
static bool GetSSDTOrg(PVOID buf,size_t size)
{
	bool bRet = false;
	if(!buf || !size) goto QUIT;
	HANDLE hKernel = LoadLibrary(g_KernelFilePath);
	if(!hKernel) goto QUIT;
	
	//ںʱSSDTԭʼݷںļУȡļƫơ
	PVOID SSDTFileOffset = (PVOID)((ULONG)hKernel + (ULONG)g_SSDTBases[0] - \
		(ULONG)g_KernelBaseRT);
	
	memcpy(buf,SSDTFileOffset,size);
	bRet = true;
QUIT:
	if(hKernel) FreeLibrary(hKernel);
	return bRet;
}

//ڿ̨ӡSSDT
static void HyPrintSSDT(bool bIsFixedOnly)
{
	static PVOID SSDT[512] = {0};
	static PVOID SSDTOrg[512] = {0};
	
	if(!HyGetSSDT(&g_shs,SSDT,sizeof(SSDT)))
	{
		PRINT("[%s]err : HyGetSSDT Failed!\n",__func__);
		goto QUIT;
	}
	
	if(!GetSSDTOrg(SSDTOrg,sizeof(SSDTOrg)))
		PRINT("[%s]err : GetSSDTOrg Failed!\n",__func__);
	
	PSYMBOL_INFO pSI = malloc(sizeof(SYMBOL_INFO)+MAX_SYM_NAME);
	if(!pSI) goto QUIT;
	pSI->SizeOfStruct = sizeof(SYMBOL_INFO);
	pSI->MaxNameLen = MAX_SYM_NAME;
	
	printf("  ID    ORG_ADDR  REAL_ADDR  SYMOL_NAME\n");   
	for(size_t i = 0;SSDT[i];++i)
	{
		if(!HySymFromAddrRaw((DWORD64)(DWORD)GetKernelOffsetLD(SSDT[i]),\
			pSI))
		{
			//SSDTѱHOOKED,SSDTOrgԭʼ
			if(!HySymFromAddrRaw((DWORD64)(DWORD)SSDTOrg[i],pSI))
				strcpy(pSI->Name,"<Unknow Symbol>");
		}
		
		DWORD OrgAddr = (ULONG)SSDTOrg[i] - (ULONG)g_KernelBaseLD + \
			(ULONG)g_KernelBaseRT;
		if(!bIsFixedOnly || (PVOID)OrgAddr != SSDT[i])
		{
			PrintSSDTItem(i,(PVOID)OrgAddr,SSDT[i],pSI->Name);
			//ûesc˳ӡ
			if(WaitAnyKey(i)) break;
		}
	}	
QUIT:
	free(pSI);
	return;
}

//ʱWin32kеĵַתΪWin32k.sysļеĶӦƫƵַ
inline PVOID GetWin32kOffsetLD(PVOID AddrRT)
{
	return (PVOID)((ULONG)AddrRT - (ULONG)g_Win32kBaseRT + (ULONG)g_Win32kBaseLD);
}

//ڿ̨ӡSSDTSdw
static void HyPrintSSDTSdw(bool bIsFixedOnly)
{
	static PVOID SSDTSdw[1024] = {0};
	static PVOID SSDTSdwOrg[1024] = {0};
	if(!g_pSSDTSdw) goto QUIT;
	if(!HyGetSSDTSdw(&g_shs,g_pSSDTSdw,SSDTSdw,\
		sizeof(SSDTSdw)))
	{
		PRINT("[%s]err : HyGetSSDTSdw Failed!\n",__func__);
		goto QUIT;
	}
		
	if(!GetSSDTSdwOrg(SSDTSdwOrg,sizeof(SSDTSdwOrg)))
		PRINT("[%s]err : GetSSDTSdwOrg Failed!\n",__func__);
		
	PSYMBOL_INFO pSI = malloc(sizeof(SYMBOL_INFO)+MAX_SYM_NAME);
	if(!pSI) goto QUIT;
	pSI->SizeOfStruct = sizeof(SYMBOL_INFO);
	pSI->MaxNameLen = MAX_SYM_NAME;
	
	printf("  ID    ORG_ADDR  REAL_ADDR  SYMOL_NAME\n");
	for(size_t i = 0;SSDTSdw[i];++i)
	{
		if(!HySymFromAddrRaw((DWORD64)(DWORD)GetWin32kOffsetLD(SSDTSdw[i]),\
			pSI))
		{
			//SSDTSdwѱHOOKED,SSDTSdwOrgԭʼ
			if(!HySymFromAddrRaw((DWORD64)(DWORD)SSDTSdwOrg[i],pSI))
				strcpy(pSI->Name,"<Unknow Symbol>");
		}
		
		DWORD OrgAddr = (ULONG)SSDTSdwOrg[i] - (ULONG)g_Win32kBaseLD + \
			(ULONG)g_Win32kBaseRT;
		if(!bIsFixedOnly || (PVOID)OrgAddr != SSDTSdw[i])
		{
			PrintSSDTItem(i,(PVOID)OrgAddr,SSDTSdw[i],pSI->Name);
			//ûesc˳ӡ
			if(WaitAnyKey(i)) break;
		}
	}
QUIT:
	free(pSI);
	return;
}

//ȡںļԼWin32kļ·Ϣ
static void GetSysFilePath(void)
{
	char SysPath[MAX_PATH];
	GetSystemDirectory(SysPath,sizeof(SysPath));
	//ں˿PAEںļΪntkrnlpa,Ϊntoskrnl
	if(HyIsOpenPAE())
		strcpy(g_KernelFileName,"ntkrnlpa");
	else
		strcpy(g_KernelFileName,"ntoskrnl");
	
	//ںļ·
	strcpy(g_KernelFilePath,SysPath);
	strcat(g_KernelFilePath,"\\");
	strcat(g_KernelFilePath,g_KernelFileName);
	strcat(g_KernelFilePath,".exe");
	PRINT("%s\n",g_KernelFilePath);
	
	//Win32kļ·
	strcpy(g_Win32kFilePath,SysPath);
	strcat(g_Win32kFilePath,"\\");
	strcat(g_Win32kFilePath,g_pWin32kFileName);
	strcat(g_Win32kFilePath,".sys");
	PRINT("%s\n",g_Win32kFilePath);
}

//ʼںϢ,ҪںļPDBϢ
static bool InitKernelInfo(void)
{
	bool bRet = false;
	//ںļPDB
	if(!HyLoadModulePdb(g_KernelFilePath))
	{
		PRINT("[%s]err : Load NT Kernel Pdb Failed!\n",__func__);
		//goto QUIT;
	}
	//ںļ
	g_KernelBaseLD = HyLoadModule(g_KernelFilePath);
	if(!g_KernelBaseLD)
	{
		PRINT("[%s]err : Load NT Kernel File Failed!\n",__func__);
		goto QUIT;
	}
	PRINT("[%s]msg : NT Kernel LD Base : %I64x\n",__func__,g_KernelBaseLD);
	//ӡںļϢ
	HyPrintModuleInfo(g_KernelBaseLD);
	PrintErr();
	//ȡʵںļ
	if(!HyStoreModFile(g_KernelFilePath))
		PRINT("[%s]err : HyStoreModFile Failed!(%d)\n",__func__,\
			GetLastError());
	//ȡʱں˻ַ
	g_KernelBaseRT = HyGetRTModBase(g_KernelFileName);
	if(!g_KernelBaseRT)
	{
		PRINT("[%s]err : Get NT Kernel RT Base Failed!\n",__func__);
		goto QUIT;
	}
	PRINT("[%s]msg : NT Kernel RT Base : %p\n",__func__,g_KernelBaseRT);
	bRet = true;
QUIT:
	return bRet;
}

//ʼWin32kϢ,ҪWin32k.sysļPDBϢ
static bool InitWin32kInfo(void)
{
	bool bRet = false;
	//Win32k.sysPDB
	if(!HyLoadModulePdb(g_Win32kFilePath))
	{
		PRINT("[%s]err : Load NT Win32k Pdb Failed!\n",__func__);
		//goto QUIT;
	}
	//Win32k.sys
	g_Win32kBaseLD = HyLoadModule(g_Win32kFilePath);
	if(!g_Win32kBaseLD)
	{
		PRINT("[%s]err : Load NT Win32k	File Failed!\n",__func__);
		goto QUIT;
	}
	PRINT("[%s]msg : NT Win32k LD Base : %I64x\n",__func__,g_Win32kBaseLD);
	//ӡWin32k.sysļϢ
	HyPrintModuleInfo(g_Win32kBaseLD);
	PrintErr();
	//ȡʵWin32k.sysļ
	if(!HyStoreModFile(g_Win32kFilePath))
		PRINT("[%s]err : HyStoreModFile Failed!(%d)\n",__func__,\
			GetLastError());
	//ȡʱWin32k.sysַ
	g_Win32kBaseRT = HyGetRTModBase(g_pWin32kFileName);
	if(!g_Win32kBaseRT)
	{
		PRINT("[%s]err : Get NT Win32k RT Base Failed!\n",__func__);
		goto QUIT;
	}
	PRINT("[%s]msg : NT Win32k RT Base : %p\n",__func__,g_Win32kBaseRT);
	bRet = true;
QUIT:
	return bRet;
}

//Ring3ȡSSDTSdwĵַ,ʧܷNULL
static PVOID GetSSDTSdwAddr(void)
{
	//ȡSSDTSdwRawƫ
	PVOID pSSDTSdw = HyGetSymAddrRaw(g_KernelBaseLD,\
		"KeServiceDescriptorTableShadow");
	if(!pSSDTSdw)
	{
		PRINT("[%s]err : Get KeServiceDescriptorTableShadow Addr Failed!\n",\
			__func__);
		goto QUIT;
	}
	//SSDTSdwʵʱƫ
	pSSDTSdw = (PVOID)((ULONG)pSSDTSdw - (ULONG)g_KernelBaseLD + \
		(ULONG)g_KernelBaseRT);
QUIT:
	return pSSDTSdw;
}

//Ring3ȡSSDTĵַʧܷNULL
static PVOID GetSSDTAddrAtRing3(void)
{
	PVOID RetAddr = NULL;
	HANDLE hKernel = LoadLibrary(g_KernelFilePath);
	if(!hKernel)
	{
		PRINT("[%s]LoadLibrary Failed!\n",__func__);
		goto QUIT;
	}
	//ȡSSDTںļеƫ
	RetAddr = GetProcAddress(hKernel,"KeServiceDescriptorTable");
	if(!RetAddr)
	{
		PRINT("[%s]Get KeServiceDescriptorTable Addr Failed!\n",__func__);
		goto QUIT;
	}
	//SSDTʱƫ
	RetAddr = (PVOID)((ULONG)RetAddr - (ULONG)hKernel + (ULONG)g_KernelBaseRT);
QUIT:
	if(hKernel) FreeLibrary(hKernel);
	return RetAddr;
}

//ȡʱSSDT.BaseSSDTSdw.Base
static bool GetSSDTBases(void)
{
	if(!HyGetSSDTBases(&g_shs,g_SSDTBases,sizeof(g_SSDTBases)))
	{
		PRINT("[%s]err : HyGetSSDTBases Failed!\n",__func__);
		return false;
	}
	PRINT("[%s]msg SSDT.Base : %p , SSDTSdw.Base : %p\n",\
		__func__,g_SSDTBases[0],g_SSDTBases[1]);
	return true;
}

//EXEĳʼ
static bool init(void)
{
	bool bRet = false;
	//
	if(!NewSvr(&g_shs))
	{
		PRINT("[%s]err : NewSvr Failed!\n",__func__);
		goto QUIT;
	}
	//
	if(!StartSvr(&g_shs))
	{
		PRINT("[%s]err : StartSvr Failed!\n",__func__);
		goto QUIT;
	}
	//ˢںģϢ
	HyFlushSysModsInfo();
	//ȡں˺Win32kļ·
	GetSysFilePath();
	//ʼDbgHelpԴ
	if(!HyInitDbgHelp(NULL))
	{
		PRINT("[%s]err : InitDbgHelp Failed!\n",__func__);
		goto QUIT;
	}
	//ʼںϢ
	if(!InitKernelInfo()) goto QUIT;
	//ʼWin32kϢ
	if(!InitWin32kInfo()) goto QUIT;
	
	//Ring3SSDTRTַ
	g_pSSDT = GetSSDTAddrAtRing3();
	if(!g_pSSDT) goto QUIT;
	PRINT("[%s]msg : SSDT Get At Ring3 is : %p\n",__func__,g_pSSDT);
	
	//Ring3SSDT Shadowַ
	g_pSSDTSdw = GetSSDTSdwAddr();
	if(!g_pSSDTSdw) goto QUIT;
	PRINT("[%s]msg : SSDTSdw Get At Ring3 is : %p\n",__func__,g_pSSDTSdw);
	BYTE Dummy[1331];
	//ֻsysextSSDTSdwĵַ
	HyGetSSDTSdw(&g_shs,g_pSSDTSdw,&Dummy,sizeof(Dummy));
	PrintErr();
	
	if(!GetSSDTBases())
	{
		PRINT("[%s]GetSSDTBases Failed!\n",__func__);goto QUIT;
		goto QUIT;
	}
	bRet = true;
QUIT:
	return bRet;
}

//EXE
static void clear(void)
{
	//ϵͳģϢ
	HyClearSysModsInfo();
	//бҪֱжںļWin32k.sysļ
	if(g_KernelBaseLD)
	{
		if(!HyUnloadModule(g_KernelBaseLD))
			PRINT("[%s]err : Unload Kernel Failed!\n",__func__);
	}
	else g_KernelBaseLD = 0x0LLU;
	
	if(g_Win32kBaseLD)
	{
		if(!HyUnloadModule(g_Win32kBaseLD))
			PRINT("[%s]err : Unload Win32k Failed!\n",__func__);
	}
	else g_Win32kBaseLD = 0x0LLU;
	//DbgHelpԴ
	HyClearDbgHelp();
	//жط
	if(!DelSvr(&g_shs))
	{
		PRINT("[%s]err : DelSvr Failed!\n",__func__);
		PRINT("[%s]Try To Force Del The Drv!\n",__func__);
		DelSvrForce();
	}
}

//ӡʹð
static void usage(void)
{
	HyPrintColorText("NtInfoGuy! Code By è|panda hopy 2010 v1.0\n",\
		CLR_TEXT_YELLOW|CLR_TEXT_BRIGHT);
	HyPrintColorText("èblog : http://blog.csdn.net/mydo\n",\
		CLR_TEXT_RED|CLR_TEXT_BRIGHT);
	puts("\nNtInfoGuy SSDT|SSDTSDW|GDT|IDT|SYSMOD[K]|SYSVAL [fixed]");
	puts("SSDT \t: ӡϵͳ");
	puts("SSDTSDW : ӡϵͳShadow");
	puts("GDT \t: ӡȫ");
	puts("IDT \t: ӡж");
	puts("SYSMOD \t: ӡϵͳģϢ");
	puts("SYSMODK : ӡϵͳģϢ(RING0ȡ,DbgViewʾ)");
	puts("SYSVAL \t: ӡϵͳں˱ֵ");
	puts("fixed \t: ֻӡĹ");
}

int main(int argc,char *argv[])
{
	HANDLE hOut = GetStdHandle(STD_OUTPUT_HANDLE);
	//Ƿ׼̨.
	//ֹûʹ NtInfoGuy ssdt>a.txt ضλ
	//WaitAnyKeyȴû롣
	g_bIsStdOut = (int)hOut == CONSOLE_STDOUT ;	//7:׼̨
	
	if(!init())
	{
		printf("[%s]err : init failed!\n",__func__);
		goto QUIT;
	}
	
	if(argc > 3 || argc == 1)
	{
		usage();goto QUIT;
	}
	
	if(!strcmpi(argv[1],"SSDT"))
		HyPrintSSDT(argc==3&&!strcmpi(argv[2],"FIXED"));
	else if(!strcmpi(argv[1],"SSDTSDW"))
		HyPrintSSDTSdw(argc==3&&!strcmpi(argv[2],"FIXED"));
	else if(!strcmpi(argv[1],"GDT"))
		HyPrintGDT();
	else if(!strcmpi(argv[1],"IDT"))
		HyPrintIDT();
	else if(!strcmpi(argv[1],"SYSMOD"))
		HyPrintSysMod();
	else if(!strcmpi(argv[1],"SYSMODK"))
		EnumSysMod();
	else if(!strcmpi(argv[1],"SYSVAL"))
		HyPrintSysVal();
	else
		usage();
QUIT:
	clear();
	//getchar();
	return 0;
}
