#if !defined(COLOR_CONSOLE_H)
	#define COLOR_CONSOLE_H

	#include <stdbool.h>
	#include <stdio.h>
	#include <stdlib.h>
	#include <string.h>
	#include <windows.h>

	#define COMMON_LVB_UNDERSCORE 0x8000
	#define COMMON_LVB_GRID_HORIZONTAL 0x400
	#define COMMON_LVB_GRID_LVERTICAL 0x800
	#define COMMON_LVB_GRID_RVERTICAL 0x1000
	
	typedef enum _Color
	{
		CLR_TEXT_RED = FOREGROUND_RED,				//ֺɫ
		CLR_BG_RED = BACKGROUND_RED,				//ɫ
		CLR_TEXT_BLUE = FOREGROUND_BLUE,			//ɫ
		CLR_BG_BLUE = BACKGROUND_BLUE,				//ɫ
		CLR_TEXT_GREEN = FOREGROUND_GREEN,			//ɫ
		CLR_BG_GREEN = BACKGROUND_GREEN,			//ɫ
		CLR_TEXT_YELLOW = FOREGROUND_RED|FOREGROUND_GREEN,	//ֻɫ			
		CLR_BG_YELLOW = BACKGROUND_RED|BACKGROUND_GREEN,	//ɫ
		CLR_TEXT_PINK = FOREGROUND_BLUE|FOREGROUND_RED,		//ַɫ
		CLR_BG_PINK = BACKGROUND_BLUE|BACKGROUND_RED,		//ɫ
		CLR_TEXT_CYAN = FOREGROUND_BLUE|FOREGROUND_GREEN,	//ɫ
		CLR_BG_CYAN = BACKGROUND_BLUE|BACKGROUND_GREEN,		//ɫ
		CLR_TEXT_WHITE = FOREGROUND_RED|FOREGROUND_BLUE|FOREGROUND_GREEN,	//ְɫ
		CLR_BG_WHITE = BACKGROUND_RED|BACKGROUND_BLUE|BACKGROUND_GREEN,		//ɫ
		CLR_TEXT_BRIGHT = FOREGROUND_INTENSITY,								//ɫ
		CLR_BG_BRIGHT = BACKGROUND_INTENSITY,								//ɫ
		CLR_TEXT_UNDERLINE = COMMON_LVB_UNDERSCORE,							//»
		CLR_TEXT_JAIL = COMMON_LVB_GRID_HORIZONTAL|\
						COMMON_LVB_GRID_LVERTICAL|\
						COMMON_LVB_GRID_RVERTICAL|\
						COMMON_LVB_UNDERSCORE,								//
	}Color;

	bool HyPrintColorText(const char *pText,USHORT color);
#endif
