#include <stdlib.h>
#include <stdbool.h>
#include <stdio.h>
#include <windows.h>
#include <Wincrypt.h>
#include "gccWintrust.h"

//ӡwin NTϢ
static void PrintErr(void)
{
	char *buf;
	DWORD ErrID = GetLastError();
	
	if(FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER |\
		FORMAT_MESSAGE_IGNORE_INSERTS | FORMAT_MESSAGE_FROM_SYSTEM,\
		NULL,ErrID,LANG_NEUTRAL,(LPTSTR)&buf,0,NULL) == 0)
	{
		printf("[%s]FormatMessage Failed!\n",__func__);
		return;
	}
	
	printf("Err Code : %08x [ %d ]\n",(unsigned)ErrID,\
		(unsigned)ErrID);
	printf("Err Text : %s\n",buf);
	
	if(LocalFree(buf) != NULL)
	{
		printf("[%s]LocalFree Failed!\n",__func__);
	}
}

bool CheckFileTrust(LPCWSTR lpFileName)
{
    bool bRet = false;
    WINTRUST_DATA wd = {0};
    WINTRUST_FILE_INFO wfi = {0};
    WINTRUST_CATALOG_INFO wci = {0};
    CATALOG_INFO ci = {0};

    HCATADMIN hCatAdmin = NULL;
    if (!CryptCATAdminAcquireContext(&hCatAdmin, NULL,0))
    {
        return false;
    }

    HANDLE hFile = CreateFileW(lpFileName,GENERIC_READ,FILE_SHARE_READ,\
        NULL,OPEN_EXISTING,0,NULL);
    if(INVALID_HANDLE_VALUE == hFile)
    {
        CryptCATAdminReleaseContext(hCatAdmin, 0);
        return false;
    }

    DWORD dwCnt = 100;
    BYTE byHash[100];
    CryptCATAdminCalcHashFromFileHandle(hFile,&dwCnt,byHash,0);
    CloseHandle(hFile);

    //LPWSTR pszMemberTag = new WCHAR[dwCnt * 2 + 1];
	LPWSTR pszMemberTag = malloc((dwCnt*2+1)*sizeof(WCHAR));
    for(DWORD dw = 0;dw < dwCnt;++dw )
    {
        wsprintfW(&pszMemberTag[dw * 2],L"%02X",byHash[dw]);
    }

    HCATINFO hCatInfo = (HCATINFO)CryptCATAdminEnumCatalogFromHash(\
		hCatAdmin,byHash,dwCnt,0,NULL);
    if(NULL == hCatInfo)
    {
        wfi.cbStruct       = sizeof(WINTRUST_FILE_INFO);
        wfi.pcwszFilePath  = lpFileName;
        wfi.hFile          = NULL;
        wfi.pgKnownSubject = NULL;
        wd.cbStruct            = sizeof(WINTRUST_DATA);
        wd.dwUnionChoice       = WTD_CHOICE_FILE;
        wd.noname.pFile        = &wfi;
        wd.dwUIChoice          = WTD_UI_NONE;
        wd.fdwRevocationChecks = WTD_REVOKE_NONE;
        wd.dwStateAction       = WTD_STATEACTION_IGNORE;
        wd.dwProvFlags         = WTD_SAFER_FLAG;
        wd.hWVTStateData       = NULL;
        wd.pwszURLReference    = NULL;
    }
    else
    {
        CryptCATCatalogInfoFromContext(hCatInfo,&ci,0);
        wci.cbStruct             = sizeof(WINTRUST_CATALOG_INFO);
        wci.pcwszCatalogFilePath = ci.wszCatalogFile;
        wci.pcwszMemberFilePath  = lpFileName;
        wci.pcwszMemberTag       = pszMemberTag;
        wd.cbStruct            = sizeof(WINTRUST_DATA);
        wd.dwUnionChoice       = WTD_CHOICE_CATALOG;
        wd.noname.pCatalog            = &wci;
        wd.dwUIChoice          = WTD_UI_NONE;
        wd.fdwRevocationChecks = WTD_STATEACTION_VERIFY;
        wd.dwProvFlags         = 0;
        wd.hWVTStateData       = NULL;
        wd.pwszURLReference    = NULL;
    }
    GUID action = WINTRUST_ACTION_GENERIC_VERIFY_V2;
    HRESULT hr  = WinVerifyTrust(NULL,&action,&wd);
    bRet        = SUCCEEDED(hr);

    if (NULL != hCatInfo)
    {
        CryptCATAdminReleaseCatalogContext(hCatAdmin,hCatInfo,0);
    }
    CryptCATAdminReleaseContext(hCatAdmin,0); // 2007.4.10лͯ־ָһڴй©
    free(pszMemberTag);
    return bRet;
}

int main(int argc,char *argv[])
{	
	if(argc!=2)
	{
		puts("usage : trust path");
		goto QUIT;
	}
	
	wchar_t PathW[MAX_PATH];
	mbstowcs(PathW,argv[1],sizeof(PathW));
	wprintf(L"%s\n",PathW);

	if(CheckFileTrust(PathW))
		puts("yes!!!!is Trust File!!!");
	else
		PrintErr();
QUIT:
	return 0;
}
