#include "disarm.h"

typedef struct thblsuffix {
	QByte offset		: 11;
	QByte mustbe11111	: 5;
} TBLSuffix;

typedef struct thblxprefix {
	QByte offset		: 11;
	QByte mustbe11110	: 5;
} TBLXPrefix;

typedef struct thundefinedone {
	QByte mustbe1		: 1;
	QByte dontcare		: 10;
	QByte mustbe11101	: 5;
} TUndefinedOne;

typedef struct thblxsuffix {
	QByte mustbe0		: 1;
	QByte dontcare		: 10;
	QByte mustbe11101	: 5;
} TBLXSuffix;

typedef struct thunditionbranch {
	QByte offset		: 11;
	QByte mustbe11100	: 5;
} TUncondBranch;


typedef struct thsoftinterrupt{
	QByte immediate		: 8;
	QByte mustbe1111	: 4;
	QByte mustbe1101	: 4;
} TSoftInterrupt;

typedef struct thundefinedtwo{
	QByte dontcare		: 8;
	QByte mustbe1110	: 4;
	QByte mustbe1101	: 4;
} TUndefinedTwo;


typedef struct thconditionalbranch{
	QByte offset		: 8;
	QByte cond			: 4;
	QByte mustbe1101	: 4;
} TCondBranch;


typedef struct thloadstoremultiple{
	QByte registerlist	: 8;
	QByte Rn			: 3;
	QByte L				: 1;
	QByte mustbe1100	: 4;
} TLoadStoreMultiple;

typedef struct thmiscellaneous{
	QByte miscel		: 12;
	QByte mustbe1011	: 4;
} TMiscellaneous;

typedef struct thaddtosporpc{
	QByte immediate		: 8;
	QByte Rd			: 3;
	QByte SP			: 1;
	QByte mustbe1010	: 4;
} TAddToSPOrPC;


typedef struct thldsttofromstack{
	QByte spoffset		: 8;
	QByte Rd			: 3;
	QByte L				: 1;
	QByte mustbe1001	: 4;
} TLdStToFromStack;


typedef struct thldsthwimme{
	QByte Rd			: 3;
	QByte Rn			: 3;
	QByte offset        : 5;
	QByte L				: 1;
	QByte mustbe1000	: 4;
} TLdStHwImme;


typedef struct thldstwbimme{
	QByte Rd			: 3;
	QByte Rn			: 3;
	QByte offset        : 5;
	QByte L				: 1;
	QByte B				: 1;
	QByte mustbe011		: 3;
} TLdStWBImme;


typedef struct thldstregoffset{
	QByte Rd			: 3;
	QByte Rn			: 3;
	QByte Rm			: 3;
	QByte opcode		: 3;
	QByte mustbe0101	: 4;
} TLdStRegOffset;



typedef struct thloadfromiteral{
	QByte pcoffset		: 8;
	QByte Rd			: 3;
	QByte mustbe01001	: 5;
} TLoadFromIteral;



typedef struct thbranchexchange{
	QByte SBZ			: 3;
	QByte Rm			: 3;
	QByte H2            : 1;
	QByte L				: 1;
	QByte mustbe11      : 2;
	QByte mustbe010001	: 6;
} TBranchExchange;

typedef struct thspecialdataproc{
	QByte RdOrRn		: 3;
	QByte Rm			: 3;
	QByte H2            : 1;
	QByte H1			: 1;
	QByte opcode        : 2;
	QByte mustbe010001	: 6;
} SpecialDataProc;

typedef struct thdataprocessingregister{
	QByte RdOrRn		: 3;
	QByte RmOrRs		: 3;
	QByte opcode        : 4;
	QByte mustbe010000	: 6;
} TDataProcReg;


typedef struct thaddsubcommovimme{
	QByte immediate		: 8;
	QByte RdOrRn		: 3;
	QByte opcode        : 2;
	QByte mustbe001		: 3;
} TASCMImme;

typedef struct thaddsubimme{
	QByte Rd			: 3;
	QByte Rn			: 3;
	QByte immediate		: 3;
	QByte opc			: 1;
	QByte mustbe1		: 1;
	QByte mustbe11		: 2;
	QByte mustbe000		: 3;
} TAddSubImme;

typedef struct AddSubReg{
	QByte Rd			: 3;
	QByte Rn			: 3;
	QByte Rm			: 3;
	QByte opc			: 1;
	QByte mustbe0		: 1;
	QByte mustbe11		: 2;
	QByte mustbe000		: 3;
} TAddSubReg;


typedef struct ShiftByImme{
	QByte Rd			: 3;
	QByte Rm			: 3;
	QByte immediate     : 5;
	QByte opcode		: 2;
	QByte mustbe000		: 3;
} TShiftByImme;
