
#ifndef _disarm_h
#define _disarm_h

#define DISARM_MAXSTRINGSIZE 256

typedef unsigned  int RawInstruction;


#ifdef __cplusplus
extern "C"  {
#endif 

char *disarm (unsigned long int instruction, int offset);


#define TRUE (0==0)
#define FALSE (0==1)

#define DISARM_COMMENTPOS 32
#define DISARM_RLCOMMENTPOS 47

typedef enum operatecode
{
	AND
   ,EOR
   ,SUB
   ,RSB
   ,ADD
   ,ADC
   ,SBC
   ,RSC
   ,TST
   ,TEQ
   ,CMP
   ,CMN
   ,OPR
   ,MOV
   ,BIC
   ,MVN
}OperCode;


/* Type definitions for instructions */
typedef unsigned long int QByte; /* 32 bits */
typedef int CondPosT;

typedef struct dbytes {
	QByte dbyte0 : 16; QByte dbyte1 : 16;
} DBytes;

typedef struct bytes {
	QByte byte0 : 8; QByte byte1 : 8; QByte byte2 : 8; QByte byte3 : 8;
} Bytes;

typedef struct nybbles {
	QByte nybble0 : 4; QByte nybble1 : 4; QByte nybble2 : 4; QByte nybble3 : 4;
	QByte nybble4 : 4; QByte nybble5 : 4; QByte nybble6 : 4; QByte nybble7 : 4;
} Nybbles;

typedef struct bits {
	QByte bit00 : 1; QByte bit01 : 1; QByte bit02 : 1; QByte bit03 : 1;
	QByte bit04 : 1; QByte bit05 : 1; QByte bit06 : 1; QByte bit07 : 1;
	QByte bit08 : 1; QByte bit09 : 1; QByte bit10 : 1; QByte bit11 : 1;
	QByte bit12 : 1; QByte bit13 : 1; QByte bit14 : 1; QByte bit15 : 1;
	QByte bit16 : 1; QByte bit17 : 1; QByte bit18 : 1; QByte bit19 : 1;
	QByte bit20 : 1; QByte bit21 : 1; QByte bit22 : 1; QByte bit23 : 1;
	QByte bit24 : 1; QByte bit25 : 1; QByte bit26 : 1; QByte bit27 : 1;
	QByte bit28 : 1; QByte bit29 : 1; QByte bit30 : 1; QByte bit31 : 1;
} Bits;

typedef struct swi {
	QByte comment : 24;
	QByte mustbe1111 : 4;
	QByte condition : 4;
} SWI;

typedef struct cpregtrans {
	QByte CRm : 4;
	QByte mustbe1 : 1;
	QByte CP : 3;
	QByte CPNum : 4;
	QByte Rd : 4;
	QByte CRn : 4;
	QByte L : 1;
	QByte CPOpc : 3;
	QByte mustbe1110 : 4;
	QByte condition : 4;
} CPRegTrans;

typedef struct cpdataop {
	QByte CRm : 4;
	QByte mustbe0 : 1;
	QByte CP : 3;
	QByte CPNum : 4;
	QByte CRd : 4;
	QByte CRn : 4;
	QByte CPOpc : 4;
	QByte mustbe1110 : 4;
	QByte condition : 4;
} CPDataOp;

typedef struct cpdatatrans {
	QByte offset : 8;
	QByte CPNum : 4;
	QByte CRd : 4;
	QByte Rn : 4;
	QByte L : 1;
	QByte W : 1;
	QByte N : 1;
	QByte U : 1;
	QByte P : 1;
	QByte mustbe110 : 3;
	QByte condition : 4;
} CPDataTrans;

typedef struct branch {
	QByte offset : 23;
	QByte sign : 1;
	QByte L : 1;
	QByte mustbe101 : 3;
	QByte condition : 4;
} Branch;

typedef struct blockdatatrans {
	QByte registerlist : 16;
	QByte Rn : 4;
	QByte L : 1;
	QByte W : 1;
	QByte S : 1;
	QByte U : 1;
	QByte P : 1;
	QByte mustbe100 : 3;
	QByte condition : 4;
} BlockDataTrans;

typedef struct dataprocimmediate{
	QByte operand2 : 12;
	QByte Rd : 4;
	QByte Rn : 4;
	QByte S : 1;
	QByte opcode : 4;
	QByte mustbe001 : 3;
	QByte condition : 4;
} DataProcImmediate;

typedef struct undefined {
	QByte dontcareA : 4;
	QByte mustbe1 : 1;
	QByte dontcareB : 20;
	QByte mustbe011 : 3;
	QByte condition : 4;
} Undefined;

typedef struct undefined4 {
	QByte dontcare : 25;
	QByte mustbe100 : 3;
	QByte condition1111 : 4;
} Undefined4;

typedef struct undefined47 {
	QByte dontcare : 27;
	QByte mustbe1 : 1;
	QByte condition1111 : 4;
} Undefined47;

typedef struct undefined3 {
	QByte dontcareA : 20;
	QByte mustbe00:	  2;
	QByte dontcareB : 1;
	QByte mustbe10:	  2;
	QByte mustbe001 : 3;
	QByte condition : 4;
} Undefined3;


typedef struct multiplyLoadStore {
	QByte registerlist : 16;
	QByte Rn : 4;
	QByte L : 1;
	QByte W : 1;
	QByte S : 1;
	QByte U : 1;
	QByte P : 1;
	QByte mustbe100 : 3;
	QByte condition : 4;
} LoadStoreMultiple;

typedef struct singledatatrans {
	QByte offset : 12;
	QByte Rd : 4;
	QByte Rn : 4;
	QByte L : 1;
	QByte W : 1;
	QByte B : 1;
	QByte U : 1;
	QByte P : 1;
	QByte I : 1;
	QByte mustbe01 : 2;
	QByte condition : 4;
} SingleDataTrans;

typedef struct singledataswap {
	QByte Rm : 4;
	QByte mustbe00001001 : 8;
	QByte Rd : 4;
	QByte Rn : 4;
	QByte mustbe00 : 2;
	QByte B : 1;
	QByte mustbe00010 : 5;
	QByte condition : 4;
} SingleDataSwap;

typedef struct multiply {
	QByte Rm			: 4;
	QByte mustbe1001	: 4;
	QByte Rs			: 4;
	QByte Rn			: 4;
	QByte Rd			: 4;
	QByte S				: 1;
	QByte A				: 1;
	QByte U				: 1;
	QByte LongMul		: 1;
	QByte mustbe0000	: 4;
	QByte condition		: 4;
} Multiply;


typedef struct multiplyextraloadstore {
	QByte dontcareA : 4;
	QByte mustbeL1 : 1;
	QByte dontcareB : 2;
	QByte mustbeH1 : 1;
	QByte dontcareC : 17;
	QByte mustbe000 : 3;
	QByte condition : 4;
} MultiplyExtraLoadStore;


typedef struct miscelone {
	QByte dontcareA : 4;
	QByte mustbe1	: 1;
	QByte dontcareB : 2;
	QByte mustbe0L  : 1;
	QByte dontcareC : 12;
	QByte mustbe0H	: 1;
	QByte dontcareD : 2;
	QByte mustbe10	: 2;
	QByte mustbe000 : 3;
	QByte condition : 4;
} MiscellanesInstructOne;


typedef struct dataprocregshift {
	QByte Rm        : 4;
	QByte mustbe1   : 1;
	QByte shift     : 2;
	QByte mustbe0   : 1;
	QByte Rs        : 4;
	QByte Rd        : 4;
	QByte Rn        : 4;
	QByte S         : 1;
	QByte opcode    : 4;
	QByte mustbe000 : 3;
	QByte condition : 4;
} DataProcRegShift;


typedef struct misceltwo {
	QByte dontcareA : 4;
	QByte mustbe0L	: 1;
	QByte dontcareB : 15;
	QByte mustbe0H	: 1;
	QByte dontcareC : 2;
	QByte mustbe10	: 2;
	QByte mustbe000 : 3;
	QByte condition : 4;
} MiscellanesInstructTwo;

typedef struct dataprocimmehift {
	QByte Rm			: 4;
	QByte mustbe0		: 1;
	QByte shift			: 2;
	QByte shiftAmount	: 5;
	QByte Rd        : 4;
	QByte Rn        : 4;
	QByte S         : 1;
	QByte opcode    : 4;
	QByte mustbe000 : 3;
	QByte condition : 4;
} DataProcImmeShift;

typedef struct msrimmetostatus {
	QByte immediate     : 8;
	QByte roate			: 4;
	QByte SBO			: 4;
	QByte Mask			: 4;
	QByte mustbe10		: 2;
	QByte R				: 1;
	QByte mustbe00110	: 5;
	QByte condition		: 4;
} MSRImeToSReg;



typedef struct msrtopsrflags {
	QByte operand : 12;
	QByte mustbe1010001111 : 10;
	QByte Pd : 1;
	QByte mustbe10 : 2;
	QByte I : 1;
	QByte mustbe00 : 2;
	QByte condition : 4;
} MSRToPSRFlags;



typedef struct mrspsrtoreg {
	QByte mustbe000000000000 : 12;
	QByte Rd : 4;
	QByte mustbe001111 : 6;
	QByte Ps : 1;
	QByte mustbe00010 : 5;
	QByte condition : 4;
} MRSPSRToReg;

typedef struct dataproc {
	QByte operand2 : 12;
	QByte Rd : 4;
	QByte Rn : 4;
	QByte S : 1;
	QByte opcode : 4;
	QByte I : 1;
	QByte mustbe00 : 2;
	QByte condition : 4;
} DataProc;

typedef struct instrclz
{
	QByte Rm			: 4;
	QByte mustbe0001	: 4;
	QByte SBO1			: 4;
	QByte Rd			: 4;
	QByte SBO2			: 4;
	QByte mustbe00010110: 8;
	QByte cond			: 4;
}CmdCLZ;


typedef struct bxblxextend
{
	QByte Rm			: 4;
	QByte bxblxdif		: 4;
	QByte SBO1			: 4;
	QByte SBO2			: 4;
	QByte SBO3			: 4;
	QByte mustbe00010010: 8;
	QByte cond			: 4;
}CmdBranchExtend;


typedef struct msrReg
{
	QByte Rm			: 4;
	QByte mustbe0000	: 4;
	QByte SBZ			: 4;
	QByte SBO			: 4;
	QByte field_mask	: 4;
	QByte mustbe10		: 2;
	QByte R				: 1;
	QByte mustbe00010	: 5;
	QByte condition		: 4;
}MSRRegToPSR;

typedef union access32 {
	QByte qbyte;
	DBytes dbytes;
	Bytes bytes;
	Nybbles nybbles;
	Bits bits;
	DataProc dataproc;
	MRSPSRToReg mrspsrtoreg;
	MSRToPSRFlags msrtopsrflags;
	MSRRegToPSR msrregtopsr;
	Multiply multiply;
	SingleDataSwap singledataswap;
	SingleDataTrans singledatatrans;
	LoadStoreMultiple loadstoremultiple;
	DataProcImmediate dataprocimme;
	Undefined   undefined;
	Undefined4  undefined4;
	Undefined47 undefined47;
	Undefined3	undefined3;
	MSRImeToSReg  msrimetosreg;
	BlockDataTrans blockdatatrans;
	MultiplyExtraLoadStore  multiextraloadstore;
	MiscellanesInstructOne	miscelinstrone;
	DataProcRegShift		dataprocregshift;
	MiscellanesInstructTwo	miscelinstrtwo;
	DataProcImmeShift       dataprocimmeshit;

	Branch branch;
	CPDataTrans cpdatatrans;
	CPDataOp cpdataop;
	CPRegTrans cpregtrans;
	SWI swi;
	
} Access32;

typedef struct shiftreg {
	QByte Rm : 4;
	QByte mustbe1 : 1;
	QByte shifttype : 2;
	QByte mustbe0 : 1;
	QByte Rs : 4;
} ShiftReg;

typedef struct shiftimmed {
	QByte Rm : 4;
	QByte mustbe0 : 1;
	QByte shifttype : 2;
	QByte shiftconst : 5;
} ShiftImmed;

/* not used ? */
typedef union shiftrm {
	QByte operand : 12;
	ShiftReg shiftreg;
	ShiftImmed shiftimmed;
} ShiftRm;



#ifdef __cplusplus
}
#endif

#endif 



