#include "Main.h"

//豸link
#define WSTR_DEVICE_NAME	L"\\Device\\SrcDbgKnlDrv"
#define WSTR_LINK_NAME		L"\\DosDevices\\SrcDbgKnlDrv"

#define IOCTL_TEST_CTRL_CODE1    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x0001, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_TEST_CTRL_CODE2    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x0002, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)

NTSTATUS  DriverDispatch (IN PDEVICE_OBJECT DeviceObject, IN PIRP Irp)
{
	Irp->IoStatus.Status = STATUS_SUCCESS;
	Irp->IoStatus.Information = 0L;
	
	IoCompleteRequest( Irp, 0 );
	
	return STATUS_SUCCESS;
}

NTSTATUS  DispatchRead (IN PDEVICE_OBJECT DeviceObject, IN PIRP Irp)
{
	PIO_STACK_LOCATION pstIrpStack;
	PUCHAR pbyUserBuffer;                       
    ULONG ulSize;
	BOOLEAN blRtn = FALSE;
	static UCHAR s_byCounter = 0;

	pstIrpStack = IoGetCurrentIrpStackLocation( Irp);
	pbyUserBuffer = (PUCHAR)Irp->UserBuffer; 
    ulSize = pstIrpStack->Parameters.Read.Length;

	if ( ulSize == 1)
	{
		*pbyUserBuffer = s_byCounter++;
		blRtn = TRUE;
	}

	if ( blRtn)
	{
		Irp->IoStatus.Status = STATUS_SUCCESS;
		Irp->IoStatus.Information = 1L;
		IoCompleteRequest( Irp, 0 );
		return STATUS_SUCCESS;
	}
	else
	{
		Irp->IoStatus.Status = STATUS_UNSUCCESSFUL;
		Irp->IoStatus.Information = 0L;
		IoCompleteRequest( Irp, 0 );
		return STATUS_UNSUCCESSFUL;
	}
}

NTSTATUS  DispatchIoCtrl (IN PDEVICE_OBJECT DeviceObject, IN PIRP Irp)
{
	NTSTATUS ntStatus = STATUS_UNSUCCESSFUL;
	PUCHAR pucCrash = NULL;
	
	PIO_STACK_LOCATION irpStack = IoGetCurrentIrpStackLocation(Irp);
	//////////////////////////////////////////////////////////////////////////
	switch(irpStack->Parameters.DeviceIoControl.IoControlCode)
	{
	case IOCTL_TEST_CTRL_CODE2:
		//
		*pucCrash = 1;
		break;
	case IOCTL_TEST_CTRL_CODE1:
		DbgPrint( "Received IOCTL_TEST_CTRL_CODE1\n");
		ntStatus = STATUS_SUCCESS;
		break;
	default:
			ntStatus = STATUS_SUCCESS;	
	}
	//////////////////////////////////////////////////////////////////////////
	//
	if(ntStatus == STATUS_SUCCESS)
		Irp->IoStatus.Information = irpStack->Parameters.DeviceIoControl.OutputBufferLength;
	else
		Irp->IoStatus.Information = 0;
	Irp->IoStatus.Status = ntStatus;
	
	IoCompleteRequest( Irp, 0 );
		
	return ntStatus;
}

NTSTATUS  DriverEntry( IN PDRIVER_OBJECT DriverObject,  IN PUNICODE_STRING RegistryPath )
{
	NTSTATUS        ntStatus = STATUS_SUCCESS;
	UNICODE_STRING  strDevName, strLinkName;
	PDEVICE_OBJECT  pstDeviceObject;
	int i = 0;
	
	DbgPrint ("In DriverEntry...\r\n");
	
	//ж
	DriverObject->DriverUnload = DriverUnload;
	//豸
	RtlInitUnicodeString( &strDevName, WSTR_DEVICE_NAME );
	
	ntStatus = IoCreateDevice( DriverObject,
		0,
		&strDevName,
		FILE_DEVICE_UNKNOWN,
		0,
		FALSE,
		&pstDeviceObject
		);
	
	if (!NT_SUCCESS( ntStatus ))
	{
		return ntStatus;   
	}
	DbgPrint ("Create Device Ok.\r\n");
	
	RtlInitUnicodeString( &strLinkName, WSTR_LINK_NAME );
	ntStatus = IoCreateSymbolicLink ( &strLinkName, &strDevName);
	if (!NT_SUCCESS( ntStatus ))
	{
		IoDeleteDevice ( DriverObject->DeviceObject);
		return ntStatus;
	}
	DbgPrint ("Create SymbolicLink Ok.\r\n");
	
	for( i = 0; i < IRP_MJ_MAXIMUM_FUNCTION; i++)
	{
		DriverObject->MajorFunction[i] = DriverDispatch;  
	}
	DriverObject->MajorFunction[IRP_MJ_DEVICE_CONTROL] = DispatchIoCtrl;
	DriverObject->MajorFunction[IRP_MJ_READ] = DispatchRead;
	
	//////////////////////////////////////////////////////////////////////////
	//Do init
	
	//////////////////////////////////////////////////////////////////////////
	
	DbgPrint( "DriverEntry Success.\r\n");
	return STATUS_SUCCESS; 
}

void DriverUnload(IN PDRIVER_OBJECT DriverObject)
{
	UNICODE_STRING  strName;
	LARGE_INTEGER Interval;
	
	DbgPrint( "In DriverUnload.\r\n");
	RtlInitUnicodeString( &strName, WSTR_LINK_NAME);
	IoDeleteSymbolicLink( &strName);
	//ɾ豸
	IoDeleteDevice( DriverObject->DeviceObject);
	
	DbgPrint ("Unload Driver.\r\n");
}
