// SrcDbgKnlAppDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SrcDbgKnlApp.h"
#include "SrcDbgKnlAppDlg.h"
#include <devioctl.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IOCTL_TEST_CTRL_CODE1    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x0001, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_TEST_CTRL_CODE2    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x0002, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSrcDbgKnlAppDlg dialog

CSrcDbgKnlAppDlg::CSrcDbgKnlAppDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSrcDbgKnlAppDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSrcDbgKnlAppDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSrcDbgKnlAppDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSrcDbgKnlAppDlg)
	DDX_Control(pDX, IDC_BTNCLOSE, m_btnClose);
	DDX_Control(pDX, IDC_BTNOPEN, m_btnOpen);
	DDX_Control(pDX, IDC_TXTLOG, m_txtLog);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSrcDbgKnlAppDlg, CDialog)
	//{{AFX_MSG_MAP(CSrcDbgKnlAppDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTNOPEN, OnBtnopen)
	ON_BN_CLICKED(IDC_BTNCLOSE, OnBtnclose)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_BTNREAD, OnBtnread)
	ON_BN_CLICKED(IDC_BTNCTRL1, OnBtnctrl1)
	ON_BN_CLICKED(IDC_BTNCTRL2, OnBtnctrl2)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSrcDbgKnlAppDlg message handlers

BOOL CSrcDbgKnlAppDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_hDrv = NULL;
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSrcDbgKnlAppDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSrcDbgKnlAppDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSrcDbgKnlAppDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSrcDbgKnlAppDlg::OnBtnopen() 
{
	m_hDrv = ::CreateFile( TEXT( "\\\\.\\SrcDbgKnlDrv"), GENERIC_READ | GENERIC_WRITE
		, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING
			, 0, 0);
	if ( m_hDrv)
	{
		m_btnOpen.EnableWindow( FALSE);
		m_btnClose.EnableWindow();
		AddLog( _T( "Open Device Success.\r\n"));
	}
	else
	{
		AddLog( _T( "Open Device Fail.\r\n"));
	}
}

void CSrcDbgKnlAppDlg::OnBtnclose() 
{
	if ( m_hDrv)
	{
		::CloseHandle( m_hDrv);
		m_hDrv = NULL;
	}
	m_btnOpen.EnableWindow();
	m_btnClose.EnableWindow( FALSE);
}

void CSrcDbgKnlAppDlg::OnClose() 
{
	OnBtnclose();
	CDialog::OnClose();
}

void CSrcDbgKnlAppDlg::OnBtnread() 
{
	BYTE byData = 0;
	DWORD dwRead = 0;
	CString s;
	if ( !m_hDrv)
	{
		AddLog( _T( "Device Not Open.\r\n"));
		return;
	}

	if ( !::ReadFile( m_hDrv, &byData, 1, &dwRead, 0))
	{
		AddLog( _T( "Read Data Fail.\r\n"));
	}
	else
	{	
		s.Format( _T("Read Data OK.Data = 0x%02X.\r\n"), byData);
		AddLog( s);
	}
	return;
	
}

void CSrcDbgKnlAppDlg::AddLog(LPCTSTR lpszMsg)
{
	int n = this->m_txtLog.SendMessage( WM_GETTEXTLENGTH, 0, 0);
	m_txtLog.SetSel( n, n);
	m_txtLog.ReplaceSel( lpszMsg);
}

void CSrcDbgKnlAppDlg::OnBtnctrl1() 
{
	if ( !m_hDrv)
	{
		AddLog( _T( "Device Not Open.\r\n"));
		return;
	}

	DWORD dwRtn = 0;
	CString s;
	if ( !::DeviceIoControl( m_hDrv, IOCTL_TEST_CTRL_CODE1, NULL, 0, NULL, 0, &dwRtn, NULL))
	{
		AddLog( _T( "DeviceIoControl Fail.\r\n"));
	}
	else
	{	
		s.Format( _T("DeviceIoControl OK.\r\n"));
		AddLog( s);
	}
}

void CSrcDbgKnlAppDlg::OnBtnctrl2() 
{
	if ( !m_hDrv)
	{
		AddLog( _T( "Device Not Open.\r\n"));
		return;
	}
	
	DWORD dwRtn = 0;
	CString s;
	if ( !::DeviceIoControl( m_hDrv, IOCTL_TEST_CTRL_CODE2, NULL, 0, NULL, 0, &dwRtn, NULL))
	{
		AddLog( _T( "Crash Fail.\r\n"));
	}
}
