#include <gtk/gtk.h>
//gcc mines.c -o mines `pkg-config --cflags --libs gtk+-2.0`
struct block
{
    gint count; //ʾһΧжٸ

    gboolean mine; //Ƿ

    gboolean marked; //Ƿ񱻱

    gboolean opened; //Ƿƿ

    GtkWidget *button;
};
static struct block *map; //ͼ

static gint width=10; //Ŀ

static gint height=10; //ĸ߶

static gint mines=10; //ܹĵ

static GtkWidget *window;
static GtkWidget *mine_label; //ʾʣĵ

static GtkWidget *time_label; //ʾʣĵʱ

static GtkWidget *reset; //Ϸ¸λ

static gint button_size=25; //ÿťĴС

static gint opened_count; //ƿ˶ٸ

static gint marked_count; //Ѿ˶ٸ

static gboolean game_over; //ϷǷı־

static gint game_time;//Ϸʱļ¼

static gint i=0, j,index;
static gint size;//ͼĴС

static gboolean mark;//ڱǷ˸λ

static gboolean clicked;//ڱʾǷƿ

//Ϸʱõĺ

void gameover(gboolean won)
  {
     GtkWidget *dialog;
        gchar buf[4];
     gchar msg[100];
        game_over=TRUE;
        if(won==TRUE)//ɨ׳ɹʾϢ

          {
     g_snprintf(msg, 100, "ۣôţʱ %3d 롣", game_time);
     }
        else//ȵ׵

          { 
     g_snprintf(msg, 100, "̫вˣôˡ");
     }
        for(i=0, index=0; i<height; i++)//ϷиӶ

          {
              for(j=0; j<width; j++)
                {
                     if(map[index].opened==FALSE)
                     {
                        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(map[index].button),TRUE);
                        gtk_button_set_label(GTK_BUTTON(map[index].button), " ");
                         if(map[index].mine==FALSE) 
                          {
                             if(map[index].count==0) gtk_button_set_label(GTK_BUTTON(map[index].button), "");
                             else
                                {
                                  g_snprintf(buf, 4, "%d", map[index].count);
                                  gtk_button_set_label(GTK_BUTTON(map[index].button), buf);
                                 }
                           }
                        else gtk_button_set_label(GTK_BUTTON(map[index].button), "*");
                       }
                  index++;
               }
         }
    //ʾʾϢ

    dialog=gtk_message_dialog_new(GTK_WINDOW(window), 0,GTK_MESSAGE_INFO, GTK_BUTTONS_OK, msg);
    gtk_dialog_run(GTK_DIALOG(dialog));
    gtk_widget_destroy(dialog);
  }
//׺

void put_mines()
 {
   while(i<mines)
   {
        gint index;
    gint row, col;
    index=g_random_int_range(0, size);
    if(map[index].mine==TRUE)//˵

        continue;
    map[index].mine=TRUE;
    row=index/width;
    col=index%width; 

    //Χӵcount1 

    if(row>0)
           {
              if(col>0) map[index-width-1].count++;
              map[index-width].count++;
              if(col<width-1) map[index-width+1].count++;
           }
         if(col>0) map[index-1].count++;
         if(col<width-1) map[index+1].count++;
     if(row<height-1)
           {
               if(col>0) map[index+width-1].count++;
               map[index+width].count++;
               if(col<width-1) map[index+width+1].count++;
     }
          i++;
    }
 }
//ĳһӶӦĺ

void open_block(gint x, gint y)
 {
     gint index;
     GtkWidget *button;
     index=x+y*width;
     if(game_over==TRUE || map[index].marked==TRUE) 
        return; //ϷֹĳҶѱǵĺӴ

     button=map[index].button;
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);//ı״̬Ϊ

     clicked=TRUE;//ʾû

     if(map[index].opened==TRUE) //ֹѾ򿪵ĺ

        return;
     map[index].opened=TRUE; //򿪺

     if(map[index].mine==TRUE)//˺

        {
     gtk_button_set_label(GTK_BUTTON(button), "*");
     gameover(FALSE); //ȵϷ

     return;
    }
     if(map[index].count>0)//Χ

        {
     gchar buf[2];
     g_snprintf(buf, 2, "%d", map[index].count);
     gtk_button_set_label(GTK_BUTTON(button), buf);
    }
       opened_count++; //һƿĸ

     if(opened_count+mines==width*height)//ʤı־

        {
        gameover(TRUE); 
        return;
    }
      if(map[index].count==0)//ΧûƿΧĸ

        { 
     if(y>0)
             {
        if(x>0) open_block(x-1, y-1);
        open_block(x, y-1);
        if(x<width-1) open_block(x+1, y-1);
     }
        if(x>0) open_block(x-1, y);
        if(x<width-1) open_block(x+1, y);
        if(y<height-1)
                   {
         if(x>0) open_block(x-1, y+1);
         open_block(x, y+1);
         if(x<width-1) open_block(x+1, y+1);
         }
    }
 }
//λ

void g_reset(GtkWidget *widget,gpointer *data)
 {
    opened_count=0;
    marked_count=0;
    game_over=FALSE;
    mark=TRUE;
    clicked=FALSE;
    gtk_label_set_text(GTK_LABEL(mine_label), "10");
    for(i=0, index=0; i<height; i++)
      {
         for(j=0; j<width; j++)
          {
            map[index].mine=FALSE;
            map[index].count=0;
            map[index].marked=FALSE;
            map[index].opened=FALSE;
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(map[index].button),FALSE);
            gtk_button_set_label(GTK_BUTTON(map[index].button), " ");
            index++;
           }
       }
   i=0;
   put_mines();
}
//ʱ

gboolean tick(gpointer data)
 {
     gchar buf[8];
     if(game_over==FALSE)//ʱ

         {
           if(mark==TRUE) game_time=0,mark=FALSE;//λmarkΪTRUEʱˢΪ0

           if(clicked==TRUE)//ףʼʱ

             {
      game_time++;//Ϸʱ

      g_snprintf(buf, 8, "%d", game_time);
             }
           else g_snprintf(buf,2,"%d",game_time);//ûûʱһֱʾΪ0

           gtk_label_set_text(GTK_LABEL(time_label), buf);//ˢʱʾ

          } 
  return TRUE;//TRUEʱ

 }
//ûʱû

gboolean on_mouse_click(GtkWidget *widget,GdkEventButton *event,gpointer data)
  {
     gint index;
     gint row, col;
     gchar buf[4];
     if(game_over==TRUE) return TRUE; //Ϸʱʧȥ

     index=(gint)data;
     switch(event->button)
      {
    case 1://

        row=index/width;
        col=index%width;
        open_block(col, row);
        break;
    case 2: //м

        break;
    case 3: //Ҽ

        if(map[index].opened==TRUE)//ƿĲǺ

            break;
        //ûмǺŵļϣеȥ

        if(map[index].marked!=TRUE)
                   {
            map[index].marked=TRUE;
            gtk_button_set_label(
            GTK_BUTTON(widget), "");
            marked_count++;
         }
                else
                  {
            map[index].marked=FALSE;
            gtk_button_set_label(
            GTK_BUTTON(widget), "");
            marked_count--;
         }
        //ʾµĵ

        g_snprintf(buf, 4, "%d",mines-marked_count);
        gtk_label_set_text(GTK_LABEL(mine_label), buf);
    }
    return TRUE;
 }

gint main(gint argc,gchar **argv)
 {
   size=width*height;
   map=(struct block *)g_malloc0(sizeof(struct block)*width*height);//Ϊ0ĵڴռ

   put_mines();

  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *label;
  gtk_init(&argc,&argv);
  window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  g_signal_connect(G_OBJECT(window), "delete_event",gtk_main_quit, NULL);
  reset=gtk_button_new_with_label("reload");
  gtk_widget_set_usize(reset,100,28);
  vbox=gtk_vbox_new(FALSE, 0);
  hbox=gtk_hbox_new(FALSE, 0);
  label=gtk_label_new("Mines:");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 6);
  mine_label=gtk_label_new("10");
  gtk_box_pack_start(GTK_BOX(hbox), mine_label,FALSE, FALSE, 3);
  gtk_box_pack_start(GTK_BOX(hbox),reset,FALSE,TRUE,6);
  label=gtk_label_new("Time:");
  gtk_box_pack_start(GTK_BOX(hbox), label,FALSE, FALSE, 6);
  time_label=gtk_label_new("0");
  gtk_box_pack_start(GTK_BOX(hbox), time_label,TRUE, FALSE, 0);
  gtk_widget_show_all(hbox);
  gtk_box_pack_start(GTK_BOX(vbox), hbox,FALSE, FALSE, 0);
  for(i=0, index=0; i<height; i++)//иӵĳʼ

     {
    gint j;
    hbox=gtk_hbox_new(FALSE, 0);
    for(j=0; j<width; j++)
              {
        GtkWidget *button;
        button=gtk_toggle_button_new();
        gtk_widget_set_usize(button,
        button_size, button_size);
        g_object_set(G_OBJECT(button),"can-focus", FALSE, NULL);
        gtk_box_pack_start(GTK_BOX(hbox),button, FALSE, FALSE, 0);
        gtk_widget_show(button);
        g_signal_connect(G_OBJECT(button),"button-press-event",
        G_CALLBACK(on_mouse_click),(gpointer)index);
     map[index].button=button;
        index++;
        }
        gtk_box_pack_start(GTK_BOX(vbox), hbox,FALSE, FALSE, 0);
        gtk_widget_show(hbox);
    }
   gtk_container_add(GTK_CONTAINER(window), vbox);
   gtk_widget_show(vbox);
   gtk_widget_show(window);
   g_timeout_add(1000, (GSourceFunc)tick, NULL);//ʱ

   g_signal_connect(GTK_OBJECT(reset),"clicked",GTK_SIGNAL_FUNC(g_reset),NULL);
  
    gtk_main();
    return 0;
}
